/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.test.context.AnnotatedClassFinder;
import org.springframework.boot.test.context.example.ExampleConfig;
import org.springframework.boot.test.context.example.scan.Example;

public class AnnotatedClassFinderTests {
    private AnnotatedClassFinder finder = new AnnotatedClassFinder(SpringBootConfiguration.class);

    @Test
    public void findFromClassWhenSourceIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.finder.findFromClass((Class)null)).withMessageContaining("Source must not be null");
    }

    @Test
    public void findFromPackageWhenSourceIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.finder.findFromPackage((String)null)).withMessageContaining("Source must not be null");
    }

    @Test
    public void findFromPackageWhenNoConfigurationFoundShouldReturnNull() {
        Class config = this.finder.findFromPackage("org.springframework.boot");
        Assertions.assertThat((Class)config).isNull();
    }

    @Test
    public void findFromClassWhenConfigurationIsFoundShouldReturnConfiguration() {
        Class config = this.finder.findFromClass(Example.class);
        Assertions.assertThat((Class)config).isEqualTo(ExampleConfig.class);
    }

    @Test
    public void findFromPackageWhenConfigurationIsFoundShouldReturnConfiguration() {
        Class config = this.finder.findFromPackage("org.springframework.boot.test.context.example.scan");
        Assertions.assertThat((Class)config).isEqualTo(ExampleConfig.class);
    }
}

