/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.test.context.FilteredClassLoader;
import org.springframework.core.io.ClassPathResource;

public class FilteredClassLoaderTests {
    private static ClassPathResource TEST_RESOURCE = new ClassPathResource("org/springframework/boot/test/context/FilteredClassLoaderTestsResource.txt");

    @Test
    public void loadClassWhenFilteredOnPackageShouldThrowClassNotFound() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new String[]{FilteredClassLoaderTests.class.getPackage().getName()});){
            Assertions.assertThatExceptionOfType(ClassNotFoundException.class).isThrownBy(() -> classLoader.loadClass(this.getClass().getName()));
        }
    }

    @Test
    public void loadClassWhenFilteredOnClassShouldThrowClassNotFound() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new Class[]{FilteredClassLoaderTests.class});){
            Assertions.assertThatExceptionOfType(ClassNotFoundException.class).isThrownBy(() -> classLoader.loadClass(this.getClass().getName()));
        }
    }

    @Test
    public void loadClassWhenNotFilteredShouldLoadClass() throws Exception {
        FilteredClassLoader classLoader = new FilteredClassLoader(new Predicate[]{className -> false});
        Class loaded = classLoader.loadClass(this.getClass().getName());
        Assertions.assertThat((String)loaded.getName()).isEqualTo((Object)this.getClass().getName());
        classLoader.close();
    }

    @Test
    public void loadResourceWhenFilteredOnResourceShouldReturnNotFound() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new ClassPathResource[]{TEST_RESOURCE});){
            URL loaded = classLoader.getResource(TEST_RESOURCE.getPath());
            Assertions.assertThat((URL)loaded).isNull();
        }
    }

    @Test
    public void loadResourceWhenNotFilteredShouldLoadResource() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new Predicate[]{resourceName -> false});){
            URL loaded = classLoader.getResource(TEST_RESOURCE.getPath());
            Assertions.assertThat((URL)loaded).isNotNull();
        }
    }

    @Test
    public void loadResourcesWhenFilteredOnResourceShouldReturnNotFound() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new ClassPathResource[]{TEST_RESOURCE});){
            Enumeration loaded = classLoader.getResources(TEST_RESOURCE.getPath());
            Assertions.assertThat((boolean)loaded.hasMoreElements()).isFalse();
        }
    }

    @Test
    public void loadResourcesWhenNotFilteredShouldLoadResource() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new Predicate[]{resourceName -> false});){
            Enumeration loaded = classLoader.getResources(TEST_RESOURCE.getPath());
            Assertions.assertThat((boolean)loaded.hasMoreElements()).isTrue();
        }
    }

    @Test
    public void loadResourceAsStreamWhenFilteredOnResourceShouldReturnNotFound() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new ClassPathResource[]{TEST_RESOURCE});){
            InputStream loaded = classLoader.getResourceAsStream(TEST_RESOURCE.getPath());
            Assertions.assertThat((InputStream)loaded).isNull();
        }
    }

    @Test
    public void loadResourceAsStreamWhenNotFilteredShouldLoadResource() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new Predicate[]{resourceName -> false});){
            InputStream loaded = classLoader.getResourceAsStream(TEST_RESOURCE.getPath());
            Assertions.assertThat((InputStream)loaded).isNotNull();
        }
    }
}

