/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.boot.test.context.ImportsContextCustomizerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;

public class ImportsContextCustomizerFactoryTests {
    private ImportsContextCustomizerFactory factory = new ImportsContextCustomizerFactory();

    @Test
    public void getContextCustomizerWhenHasNoImportAnnotationShouldReturnNull() {
        ContextCustomizer customizer = this.factory.createContextCustomizer(TestWithNoImport.class, null);
        Assertions.assertThat((Object)customizer).isNull();
    }

    @Test
    public void getContextCustomizerWhenHasImportAnnotationShouldReturnCustomizer() {
        ContextCustomizer customizer = this.factory.createContextCustomizer(TestWithImport.class, null);
        Assertions.assertThat((Object)customizer).isNotNull();
    }

    @Test
    public void getContextCustomizerWhenHasMetaImportAnnotationShouldReturnCustomizer() {
        ContextCustomizer customizer = this.factory.createContextCustomizer(TestWithMetaImport.class, null);
        Assertions.assertThat((Object)customizer).isNotNull();
    }

    @Test
    public void contextCustomizerEqualsAndHashCode() {
        ContextCustomizer customizer1 = this.factory.createContextCustomizer(TestWithImport.class, null);
        ContextCustomizer customizer2 = this.factory.createContextCustomizer(TestWithImport.class, null);
        ContextCustomizer customizer3 = this.factory.createContextCustomizer(TestWithImportAndMetaImport.class, null);
        ContextCustomizer customizer4 = this.factory.createContextCustomizer(TestWithSameImportAndMetaImport.class, null);
        Assertions.assertThat((int)customizer1.hashCode()).isEqualTo(customizer1.hashCode());
        Assertions.assertThat((int)customizer1.hashCode()).isEqualTo(customizer2.hashCode());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)customizer1).isEqualTo((Object)customizer1)).isEqualTo((Object)customizer2)).isNotEqualTo((Object)customizer3);
        Assertions.assertThat((Object)customizer3).isEqualTo((Object)customizer4);
    }

    @Test
    public void getContextCustomizerWhenClassHasBeanMethodsShouldThrowException() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.factory.createContextCustomizer(TestWithImportAndBeanMethod.class, null)).withMessageContaining("Test classes cannot include @Bean methods");
    }

    @Test
    public void contextCustomizerImportsBeans() {
        ContextCustomizer customizer = this.factory.createContextCustomizer(TestWithImport.class, null);
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        customizer.customizeContext((ConfigurableApplicationContext)context, (MergedContextConfiguration)Mockito.mock(MergedContextConfiguration.class));
        context.refresh();
        Assertions.assertThat((Object)context.getBean(ImportedBean.class)).isNotNull();
    }

    @Test
    public void selfAnnotatingAnnotationDoesNotCauseStackOverflow() {
        Assertions.assertThat((Object)this.factory.createContextCustomizer(TestWithImportAndSelfAnnotatingAnnotation.class, null)).isNotNull();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SelfAnnotating
    static @interface SelfAnnotating {
    }

    @Component
    static class AnotherImportedBean {
        AnotherImportedBean() {
        }
    }

    @Component
    static class ImportedBean {
        ImportedBean() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Import(value={ImportedBean.class})
    static @interface MetaImport {
    }

    @SelfAnnotating
    @Import(value={ImportedBean.class})
    static class TestWithImportAndSelfAnnotatingAnnotation {
        TestWithImportAndSelfAnnotatingAnnotation() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={ImportedBean.class})
    static class TestWithImportAndBeanMethod {
        TestWithImportAndBeanMethod() {
        }

        @Bean
        public String bean() {
            return "bean";
        }
    }

    @MetaImport
    @Import(value={AnotherImportedBean.class})
    static class TestWithSameImportAndMetaImport {
        TestWithSameImportAndMetaImport() {
        }
    }

    @MetaImport
    @Import(value={AnotherImportedBean.class})
    static class TestWithImportAndMetaImport {
        TestWithImportAndMetaImport() {
        }
    }

    @MetaImport
    static class TestWithMetaImport {
        TestWithMetaImport() {
        }
    }

    @Import(value={ImportedBean.class})
    static class TestWithImport {
        TestWithImport() {
        }
    }

    static class TestWithNoImport {
        TestWithNoImport() {
        }
    }
}

