/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import javax.servlet.ServletContext;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootContextLoader;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@RunWith(value=SpringRunner.class)
@DirtiesContext
@ContextConfiguration(loader=SpringBootContextLoader.class)
@WebAppConfiguration
public class SpringBootContextLoaderMockMvcTests {
    @Autowired
    private WebApplicationContext context;
    @Autowired
    private ServletContext servletContext;
    private MockMvc mvc;

    @Before
    public void setUp() {
        this.mvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).build();
    }

    @Test
    public void testMockHttpEndpoint() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("Hello World"));
    }

    @Test
    public void validateWebApplicationContextIsSet() {
        Assertions.assertThat((Object)this.context).isSameAs((Object)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext));
    }

    @Configuration(proxyBeanMethods=false)
    @EnableWebMvc
    @RestController
    protected static class Config {
        protected Config() {
        }

        @RequestMapping(value={"/"})
        public String home() {
            return "Hello World";
        }
    }
}

