/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import javax.servlet.ServletContext;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@RunWith(value=SpringRunner.class)
@SpringBootTest(value={"value=123"})
@DirtiesContext
public class SpringBootTestWebEnvironmentMockTests {
    @Value(value="${value}")
    private int value = 0;
    @Autowired
    private WebApplicationContext context;
    @Autowired
    private ServletContext servletContext;

    @Test
    public void annotationAttributesOverridePropertiesFile() {
        Assertions.assertThat((int)this.value).isEqualTo(123);
    }

    @Test
    public void validateWebApplicationContextIsSet() {
        WebApplicationContext fromServletContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        Assertions.assertThat((Object)fromServletContext).isSameAs((Object)this.context);
    }

    @Test
    public void setsRequestContextHolder() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        Assertions.assertThat((Object)attributes).isNotNull();
    }

    @Test
    public void resourcePath() {
        Assertions.assertThat((Object)this.servletContext).hasFieldOrPropertyWithValue("resourceBasePath", (Object)"src/main/webapp");
    }

    @Configuration(proxyBeanMethods=false)
    @EnableWebMvc
    protected static class Config {
        protected Config() {
        }

        @Bean
        public static PropertySourcesPlaceholderConfigurer propertyPlaceholder() {
            return new PropertySourcesPlaceholderConfigurer();
        }
    }
}

