/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.AbstractSpringBootTestWebServerWebEnvironmentTests;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@RunWith(value=SpringRunner.class)
@DirtiesContext
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"value=123"})
public class SpringBootTestWebEnvironmentRandomPortTests
extends AbstractSpringBootTestWebServerWebEnvironmentTests {
    @Test
    public void testRestTemplateShouldUseBuilder() {
        Assertions.assertThat((List)this.getRestTemplate().getRestTemplate().getMessageConverters()).hasAtLeastOneElementOfType(MyConverter.class);
    }

    private static class MyConverter
    extends StringHttpMessageConverter {
        private MyConverter() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableWebMvc
    @RestController
    protected static class Config
    extends AbstractSpringBootTestWebServerWebEnvironmentTests.AbstractConfig {
        protected Config() {
        }

        @Bean
        public RestTemplateBuilder restTemplateBuilder() {
            return new RestTemplateBuilder(new RestTemplateCustomizer[0]).additionalMessageConverters(new HttpMessageConverter[]{new MyConverter()});
        }
    }
}

