/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@DirtiesContext
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE, properties={"boot-test-inlined=foo", "b=boot-test-inlined", "c=boot-test-inlined"})
@TestPropertySource(properties={"property-source-inlined=bar", "a=property-source-inlined", "c=property-source-inlined"}, locations={"classpath:/test-property-source-annotation.properties"})
public class SpringBootTestWithTestPropertySourceTests {
    @Autowired
    private Config config;

    @Test
    public void propertyFromSpringBootTestProperties() {
        Assertions.assertThat((String)this.config.bootTestInlined).isEqualTo((Object)"foo");
    }

    @Test
    public void propertyFromTestPropertySourceProperties() {
        Assertions.assertThat((String)this.config.propertySourceInlined).isEqualTo((Object)"bar");
    }

    @Test
    public void propertyFromTestPropertySourceLocations() {
        Assertions.assertThat((String)this.config.propertySourceLocation).isEqualTo((Object)"baz");
    }

    @Test
    public void propertyFromPropertySourcePropertiesOverridesPropertyFromPropertySourceLocations() {
        Assertions.assertThat((String)this.config.propertySourceInlinedOverridesPropertySourceLocation).isEqualTo((Object)"property-source-inlined");
    }

    @Test
    public void propertyFromBootTestPropertiesOverridesPropertyFromPropertySourceLocations() {
        Assertions.assertThat((String)this.config.bootTestInlinedOverridesPropertySourceLocation).isEqualTo((Object)"boot-test-inlined");
    }

    @Test
    public void propertyFromPropertySourcePropertiesOverridesPropertyFromBootTestProperties() {
        Assertions.assertThat((String)this.config.propertySourceInlinedOverridesBootTestInlined).isEqualTo((Object)"property-source-inlined");
    }

    @Configuration(proxyBeanMethods=false)
    static class Config {
        @Value(value="${boot-test-inlined}")
        private String bootTestInlined;
        @Value(value="${property-source-inlined}")
        private String propertySourceInlined;
        @Value(value="${property-source-location}")
        private String propertySourceLocation;
        @Value(value="${a}")
        private String propertySourceInlinedOverridesPropertySourceLocation;
        @Value(value="${b}")
        private String bootTestInlinedOverridesPropertySourceLocation;
        @Value(value="${c}")
        private String propertySourceInlinedOverridesBootTestInlined;

        Config() {
        }

        @Bean
        public static PropertySourcesPlaceholderConfigurer propertyPlaceholder() {
            return new PropertySourcesPlaceholderConfigurer();
        }
    }
}

