/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.filter;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.test.context.filter.AbstractJupiterTestWithConfigAndExtendWith;
import org.springframework.boot.test.context.filter.AbstractTestNgTestWithConfig;
import org.springframework.boot.test.context.filter.AbstractTestWithConfigAndRunWith;
import org.springframework.boot.test.context.filter.JupiterRepeatedTestExample;
import org.springframework.boot.test.context.filter.JupiterTestExample;
import org.springframework.boot.test.context.filter.JupiterTestFactoryExample;
import org.springframework.boot.test.context.filter.SampleConfig;
import org.springframework.boot.test.context.filter.SampleTestConfig;
import org.springframework.boot.test.context.filter.TestTypeExcludeFilter;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;

public class TestTypeExcludeFilterTests {
    private TestTypeExcludeFilter filter = new TestTypeExcludeFilter();
    private MetadataReaderFactory metadataReaderFactory = new SimpleMetadataReaderFactory();

    @Test
    public void matchesJUnit4TestClass() throws Exception {
        Assertions.assertThat((boolean)this.filter.match(this.getMetadataReader(TestTypeExcludeFilterTests.class), this.metadataReaderFactory)).isTrue();
    }

    @Test
    public void matchesJUnitJupiterTestClass() throws Exception {
        Assertions.assertThat((boolean)this.filter.match(this.getMetadataReader(JupiterTestExample.class), this.metadataReaderFactory)).isTrue();
    }

    @Test
    public void matchesJUnitJupiterRepeatedTestClass() throws Exception {
        Assertions.assertThat((boolean)this.filter.match(this.getMetadataReader(JupiterRepeatedTestExample.class), this.metadataReaderFactory)).isTrue();
    }

    @Test
    public void matchesJUnitJupiterTestFactoryClass() throws Exception {
        Assertions.assertThat((boolean)this.filter.match(this.getMetadataReader(JupiterTestFactoryExample.class), this.metadataReaderFactory)).isTrue();
    }

    @Test
    public void matchesNestedConfiguration() throws Exception {
        Assertions.assertThat((boolean)this.filter.match(this.getMetadataReader(NestedConfig.class), this.metadataReaderFactory)).isTrue();
    }

    @Test
    public void matchesNestedConfigurationClassWithoutTestMethodsIfItHasRunWith() throws Exception {
        Assertions.assertThat((boolean)this.filter.match(this.getMetadataReader(AbstractTestWithConfigAndRunWith.Config.class), this.metadataReaderFactory)).isTrue();
    }

    @Test
    public void matchesNestedConfigurationClassWithoutTestMethodsIfItHasExtendWith() throws Exception {
        Assertions.assertThat((boolean)this.filter.match(this.getMetadataReader(AbstractJupiterTestWithConfigAndExtendWith.Config.class), this.metadataReaderFactory)).isTrue();
    }

    @Test
    public void matchesTestConfiguration() throws Exception {
        Assertions.assertThat((boolean)this.filter.match(this.getMetadataReader(SampleTestConfig.class), this.metadataReaderFactory)).isTrue();
    }

    @Test
    public void doesNotMatchRegularConfiguration() throws Exception {
        Assertions.assertThat((boolean)this.filter.match(this.getMetadataReader(SampleConfig.class), this.metadataReaderFactory)).isFalse();
    }

    @Test
    public void matchesNestedConfigurationClassWithoutTestNgAnnotation() throws Exception {
        Assertions.assertThat((boolean)this.filter.match(this.getMetadataReader(AbstractTestNgTestWithConfig.Config.class), this.metadataReaderFactory)).isTrue();
    }

    private MetadataReader getMetadataReader(Class<?> source) throws IOException {
        return this.metadataReaderFactory.getMetadataReader(source.getName());
    }

    @Configuration(proxyBeanMethods=false)
    static class NestedConfig {
        NestedConfig() {
        }
    }
}

