/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.test.json.AbstractJsonMarshalTester;
import org.springframework.boot.test.json.AbstractJsonMarshalTesterTests;
import org.springframework.boot.test.json.ExampleObject;
import org.springframework.boot.test.json.GsonTester;
import org.springframework.core.ResolvableType;

public class GsonTesterTests
extends AbstractJsonMarshalTesterTests {
    @Test
    public void initFieldsWhenTestIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> GsonTester.initFields(null, (Gson)new GsonBuilder().create())).withMessageContaining("TestInstance must not be null");
    }

    @Test
    public void initFieldsWhenMarshallerIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> GsonTester.initFields((Object)new InitFieldsTestClass(), (Gson)null)).withMessageContaining("Marshaller must not be null");
    }

    @Test
    public void initFieldsShouldSetNullFields() {
        InitFieldsTestClass test = new InitFieldsTestClass();
        Assertions.assertThat(test.test).isNull();
        Assertions.assertThat((Object)test.base).isNull();
        GsonTester.initFields((Object)test, (Gson)new GsonBuilder().create());
        Assertions.assertThat(test.test).isNotNull();
        Assertions.assertThat((Object)test.base).isNotNull();
        Assertions.assertThat((Class)test.test.getType().resolve()).isEqualTo(List.class);
        Assertions.assertThat((Class)test.test.getType().resolveGeneric(new int[0])).isEqualTo(ExampleObject.class);
    }

    @Override
    protected AbstractJsonMarshalTester<Object> createTester(Class<?> resourceLoadClass, ResolvableType type) {
        return new GsonTester(resourceLoadClass, type, new GsonBuilder().create());
    }

    static class InitFieldsTestClass
    extends InitFieldsBaseClass {
        public GsonTester<List<ExampleObject>> test;
        public GsonTester<ExampleObject> testSet = new GsonTester(InitFieldsBaseClass.class, ResolvableType.forClass(ExampleObject.class), new GsonBuilder().create());

        InitFieldsTestClass() {
        }
    }

    static abstract class InitFieldsBaseClass {
        public GsonTester<ExampleObject> base;
        public GsonTester<ExampleObject> baseSet = new GsonTester(InitFieldsBaseClass.class, ResolvableType.forClass(ExampleObject.class), new GsonBuilder().create());

        InitFieldsBaseClass() {
        }
    }
}

