/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.test.json.AbstractJsonMarshalTester;
import org.springframework.boot.test.json.AbstractJsonMarshalTesterTests;
import org.springframework.boot.test.json.ExampleObject;
import org.springframework.boot.test.json.JacksonTester;
import org.springframework.core.ResolvableType;

public class JacksonTesterTests
extends AbstractJsonMarshalTesterTests {
    @Test
    public void initFieldsWhenTestIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> JacksonTester.initFields(null, (ObjectMapper)new ObjectMapper())).withMessageContaining("TestInstance must not be null");
    }

    @Test
    public void initFieldsWhenMarshallerIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> JacksonTester.initFields((Object)new InitFieldsTestClass(), (ObjectMapper)null)).withMessageContaining("Marshaller must not be null");
    }

    @Test
    public void initFieldsShouldSetNullFields() {
        InitFieldsTestClass test = new InitFieldsTestClass();
        Assertions.assertThat(test.test).isNull();
        Assertions.assertThat((Object)test.base).isNull();
        JacksonTester.initFields((Object)test, (ObjectMapper)new ObjectMapper());
        Assertions.assertThat(test.test).isNotNull();
        Assertions.assertThat((Object)test.base).isNotNull();
        Assertions.assertThat((Class)test.test.getType().resolve()).isEqualTo(List.class);
        Assertions.assertThat((Class)test.test.getType().resolveGeneric(new int[0])).isEqualTo(ExampleObject.class);
    }

    @Override
    protected AbstractJsonMarshalTester<Object> createTester(Class<?> resourceLoadClass, ResolvableType type) {
        return new JacksonTester(resourceLoadClass, type, new ObjectMapper());
    }

    static class InitFieldsTestClass
    extends InitFieldsBaseClass {
        public JacksonTester<List<ExampleObject>> test;
        public JacksonTester<ExampleObject> testSet = new JacksonTester(InitFieldsBaseClass.class, ResolvableType.forClass(ExampleObject.class), new ObjectMapper());

        InitFieldsTestClass() {
        }
    }

    static abstract class InitFieldsBaseClass {
        public JacksonTester<ExampleObject> base;
        public JacksonTester<ExampleObject> baseSet = new JacksonTester(InitFieldsBaseClass.class, ResolvableType.forClass(ExampleObject.class), new ObjectMapper());

        InitFieldsBaseClass() {
        }
    }
}

