/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.util.List;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.test.json.AbstractJsonMarshalTester;
import org.springframework.boot.test.json.AbstractJsonMarshalTesterTests;
import org.springframework.boot.test.json.ExampleObject;
import org.springframework.boot.test.json.JsonbTester;
import org.springframework.core.ResolvableType;

public class JsonbTesterTests
extends AbstractJsonMarshalTesterTests {
    @Test
    public void initFieldsWhenTestIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> JsonbTester.initFields(null, (Jsonb)JsonbBuilder.create())).withMessageContaining("TestInstance must not be null");
    }

    @Test
    public void initFieldsWhenMarshallerIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> JsonbTester.initFields((Object)new InitFieldsTestClass(), (Jsonb)null)).withMessageContaining("Marshaller must not be null");
    }

    @Test
    public void initFieldsShouldSetNullFields() {
        InitFieldsTestClass test = new InitFieldsTestClass();
        Assertions.assertThat(test.test).isNull();
        Assertions.assertThat((Object)test.base).isNull();
        JsonbTester.initFields((Object)test, (Jsonb)JsonbBuilder.create());
        Assertions.assertThat(test.test).isNotNull();
        Assertions.assertThat((Object)test.base).isNotNull();
        Assertions.assertThat((Class)test.test.getType().resolve()).isEqualTo(List.class);
        Assertions.assertThat((Class)test.test.getType().resolveGeneric(new int[0])).isEqualTo(ExampleObject.class);
    }

    @Override
    protected AbstractJsonMarshalTester<Object> createTester(Class<?> resourceLoadClass, ResolvableType type) {
        return new JsonbTester(resourceLoadClass, type, JsonbBuilder.create());
    }

    static class InitFieldsTestClass
    extends InitFieldsBaseClass {
        public JsonbTester<List<ExampleObject>> test;
        public JsonbTester<ExampleObject> testSet = new JsonbTester(InitFieldsBaseClass.class, ResolvableType.forClass(ExampleObject.class), JsonbBuilder.create());

        InitFieldsTestClass() {
        }
    }

    static abstract class InitFieldsBaseClass {
        public JsonbTester<ExampleObject> base;
        public JsonbTester<ExampleObject> baseSet = new JsonbTester(InitFieldsBaseClass.class, ResolvableType.forClass(ExampleObject.class), JsonbBuilder.create());

        InitFieldsBaseClass() {
        }
    }
}

