/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.test.json.ExampleObject;
import org.springframework.boot.test.json.ObjectContent;
import org.springframework.boot.test.json.ObjectContentAssert;
import org.springframework.core.ResolvableType;

public class ObjectContentTests {
    private static final ExampleObject OBJECT = new ExampleObject();
    private static final ResolvableType TYPE = ResolvableType.forClass(ExampleObject.class);

    @Test
    public void createWhenObjectIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new ObjectContent(TYPE, null)).withMessageContaining("Object must not be null");
    }

    @Test
    public void createWhenTypeIsNullShouldCreateContent() {
        ObjectContent content = new ObjectContent(null, (Object)OBJECT);
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)content)).isNotNull();
    }

    @Test
    public void assertThatShouldReturnObjectContentAssert() {
        ObjectContent content = new ObjectContent(TYPE, (Object)OBJECT);
        Assertions.assertThat((Object)content.assertThat()).isInstanceOf(ObjectContentAssert.class);
    }

    @Test
    public void getObjectShouldReturnObject() {
        ObjectContent content = new ObjectContent(TYPE, (Object)OBJECT);
        Assertions.assertThat((Object)content.getObject()).isEqualTo((Object)OBJECT);
    }

    @Test
    public void toStringWhenHasTypeShouldReturnString() {
        ObjectContent content = new ObjectContent(TYPE, (Object)OBJECT);
        Assertions.assertThat((String)content.toString()).isEqualTo((Object)("ObjectContent " + OBJECT + " created from " + TYPE));
    }

    @Test
    public void toStringWhenHasNoTypeShouldReturnString() {
        ObjectContent content = new ObjectContent(null, (Object)OBJECT);
        Assertions.assertThat((String)content.toString()).isEqualTo((Object)("ObjectContent " + OBJECT));
    }
}

