/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
public class MockBeanForBeanFactoryIntegrationTests {
    @MockBean
    private TestFactoryBean testFactoryBean;
    @Autowired
    private ApplicationContext applicationContext;

    @Test
    public void testName() {
        TestBean testBean = (TestBean)Mockito.mock(TestBean.class);
        BDDMockito.given((Object)testBean.hello()).willReturn((Object)"amock");
        BDDMockito.given(this.testFactoryBean.getObjectType()).willReturn(TestBean.class);
        BDDMockito.given((Object)this.testFactoryBean.getObject()).willReturn((Object)testBean);
        TestBean bean = (TestBean)this.applicationContext.getBean(TestBean.class);
        Assertions.assertThat((String)bean.hello()).isEqualTo((Object)"amock");
    }

    static interface TestBean {
        public String hello();
    }

    static class TestFactoryBean
    implements FactoryBean<TestBean> {
        TestFactoryBean() {
        }

        public TestBean getObject() {
            return () -> "normal";
        }

        public Class<?> getObjectType() {
            return TestBean.class;
        }

        public boolean isSingleton() {
            return false;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class Config {
        Config() {
        }

        @Bean
        public TestFactoryBean testFactoryBean() {
            return new TestFactoryBean();
        }
    }
}

