/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.example.CustomQualifier;
import org.springframework.boot.test.mock.mockito.example.CustomQualifierExampleService;
import org.springframework.boot.test.mock.mockito.example.ExampleService;
import org.springframework.boot.test.mock.mockito.example.ExampleServiceCaller;
import org.springframework.boot.test.mock.mockito.example.RealExampleService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
public class MockBeanOnTestFieldForExistingBeanWithQualifierIntegrationTests {
    @MockBean
    @CustomQualifier
    private ExampleService service;
    @Autowired
    private ExampleServiceCaller caller;
    @Autowired
    private ApplicationContext applicationContext;

    @Test
    public void testMocking() {
        this.caller.sayGreeting();
        ((ExampleService)Mockito.verify((Object)this.service)).greeting();
    }

    @Test
    public void onlyQualifiedBeanIsReplaced() {
        Assertions.assertThat((Object)this.applicationContext.getBean("service")).isSameAs((Object)this.service);
        ExampleService anotherService = (ExampleService)this.applicationContext.getBean("anotherService", ExampleService.class);
        Assertions.assertThat((String)anotherService.greeting()).isEqualTo((Object)"Another");
    }

    @Configuration(proxyBeanMethods=false)
    static class TestConfig {
        TestConfig() {
        }

        @Bean
        public CustomQualifierExampleService service() {
            return new CustomQualifierExampleService();
        }

        @Bean
        public ExampleService anotherService() {
            return new RealExampleService("Another");
        }

        @Bean
        public ExampleServiceCaller controller(@CustomQualifier ExampleService service) {
            return new ExampleServiceCaller(service);
        }
    }
}

