/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.MockitoContextCustomizerFactory;
import org.springframework.test.context.ContextCustomizer;

public class MockitoContextCustomizerFactoryTests {
    private final MockitoContextCustomizerFactory factory = new MockitoContextCustomizerFactory();

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void getContextCustomizerWithoutAnnotationReturnsCustomizer() {
        ContextCustomizer customizer = this.factory.createContextCustomizer(NoMockBeanAnnotation.class, null);
        Assertions.assertThat((Object)customizer).isNotNull();
    }

    @Test
    public void getContextCustomizerWithAnnotationReturnsCustomizer() {
        ContextCustomizer customizer = this.factory.createContextCustomizer(WithMockBeanAnnotation.class, null);
        Assertions.assertThat((Object)customizer).isNotNull();
    }

    @Test
    public void getContextCustomizerUsesMocksAsCacheKey() {
        ContextCustomizer customizer = this.factory.createContextCustomizer(WithMockBeanAnnotation.class, null);
        Assertions.assertThat((Object)customizer).isNotNull();
        ContextCustomizer same = this.factory.createContextCustomizer(WithSameMockBeanAnnotation.class, null);
        Assertions.assertThat((Object)customizer).isNotNull();
        ContextCustomizer different = this.factory.createContextCustomizer(WithDifferentMockBeanAnnotation.class, null);
        Assertions.assertThat((Object)different).isNotNull();
        Assertions.assertThat((int)customizer.hashCode()).isEqualTo(same.hashCode());
        Assertions.assertThat((int)customizer.hashCode()).isNotEqualTo(different.hashCode());
        Assertions.assertThat((Object)customizer).isEqualTo((Object)customizer);
        Assertions.assertThat((Object)customizer).isEqualTo((Object)same);
        Assertions.assertThat((Object)customizer).isNotEqualTo((Object)different);
    }

    static interface Service2 {
    }

    static interface Service1 {
    }

    @MockBean(value={Service1.class})
    static class WithDifferentMockBeanAnnotation {
        WithDifferentMockBeanAnnotation() {
        }
    }

    @MockBean(value={Service2.class, Service1.class})
    static class WithSameMockBeanAnnotation {
        WithSameMockBeanAnnotation() {
        }
    }

    @MockBean(value={Service1.class, Service2.class})
    static class WithMockBeanAnnotation {
        WithMockBeanAnnotation() {
        }
    }

    static class NoMockBeanAnnotation {
        NoMockBeanAnnotation() {
        }
    }
}

