/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.springframework.boot.test.mock.mockito.MockDefinition;
import org.springframework.boot.test.mock.mockito.MockitoContextCustomizer;
import org.springframework.boot.test.mock.mockito.example.ExampleService;
import org.springframework.boot.test.mock.mockito.example.ExampleServiceCaller;
import org.springframework.core.ResolvableType;

public class MockitoContextCustomizerTests {
    private static final Set<MockDefinition> NO_DEFINITIONS = Collections.emptySet();

    @Test
    public void hashCodeAndEquals() {
        MockDefinition d1 = this.createTestMockDefinition(ExampleService.class);
        MockDefinition d2 = this.createTestMockDefinition(ExampleServiceCaller.class);
        MockitoContextCustomizer c1 = new MockitoContextCustomizer(NO_DEFINITIONS);
        MockitoContextCustomizer c2 = new MockitoContextCustomizer(new LinkedHashSet<MockDefinition>(Arrays.asList(d1, d2)));
        MockitoContextCustomizer c3 = new MockitoContextCustomizer(new LinkedHashSet<MockDefinition>(Arrays.asList(d2, d1)));
        Assertions.assertThat((int)c2.hashCode()).isEqualTo(c3.hashCode());
        ((ObjectAssert)Assertions.assertThat((Object)c1).isEqualTo((Object)c1)).isNotEqualTo((Object)c2);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)c2).isEqualTo((Object)c2)).isEqualTo((Object)c3)).isNotEqualTo((Object)c1);
    }

    private MockDefinition createTestMockDefinition(Class<?> typeToMock) {
        return new MockDefinition(null, ResolvableType.forClass(typeToMock), null, null, false, null, null);
    }
}

