/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.boot.test.mock.mockito.example.ExampleGenericService;
import org.springframework.boot.test.mock.mockito.example.ExampleGenericServiceCaller;
import org.springframework.boot.test.mock.mockito.example.SimpleExampleIntegerGenericService;
import org.springframework.boot.test.mock.mockito.example.SimpleExampleStringGenericService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
public class SpyBeanOnTestFieldForExistingGenericBeanIntegrationTests {
    @SpyBean
    private ExampleGenericService<String> exampleService;
    @Autowired
    private ExampleGenericServiceCaller caller;

    @Test
    public void testSpying() {
        Assertions.assertThat((String)this.caller.sayGreeting()).isEqualTo((Object)"I say 123 simple");
        ((ExampleGenericService)Mockito.verify(this.exampleService)).greeting();
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={ExampleGenericServiceCaller.class, SimpleExampleIntegerGenericService.class})
    static class SpyBeanOnTestFieldForExistingBeanConfig {
        SpyBeanOnTestFieldForExistingBeanConfig() {
        }

        @Bean
        public ExampleGenericService<String> simpleExampleStringGenericService() {
            return new SimpleExampleStringGenericService();
        }
    }
}

