/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.boot.test.mock.mockito.example.ExampleGenericStringServiceCaller;
import org.springframework.boot.test.mock.mockito.example.SimpleExampleStringGenericService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
public class SpyBeanOnTestFieldForMultipleExistingBeansWithOnePrimaryIntegrationTests {
    @SpyBean
    private SimpleExampleStringGenericService spy;
    @Autowired
    private ExampleGenericStringServiceCaller caller;

    @Test
    public void testSpying() {
        Assertions.assertThat((String)this.caller.sayGreeting()).isEqualTo((Object)"I say two");
        Assertions.assertThat((String)Mockito.mockingDetails((Object)this.spy).getMockCreationSettings().getMockName().toString()).isEqualTo((Object)"two");
        ((SimpleExampleStringGenericService)Mockito.verify((Object)this.spy)).greeting();
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={ExampleGenericStringServiceCaller.class})
    static class Config {
        Config() {
        }

        @Bean
        public SimpleExampleStringGenericService one() {
            return new SimpleExampleStringGenericService("one");
        }

        @Bean
        @Primary
        public SimpleExampleStringGenericService two() {
            return new SimpleExampleStringGenericService("two");
        }
    }
}

