/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.util;

import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.util.ApplicationContextTestUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ApplicationContextTestUtilsTests {
    @Test
    public void closeNull() {
        ApplicationContextTestUtils.closeAll(null);
    }

    @Test
    public void closeNonClosableContext() {
        ApplicationContext mock = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        ApplicationContextTestUtils.closeAll((ApplicationContext)mock);
    }

    @Test
    public void closeContextAndParent() {
        ConfigurableApplicationContext mock = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        ConfigurableApplicationContext parent = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        BDDMockito.given((Object)mock.getParent()).willReturn((Object)parent);
        BDDMockito.given((Object)parent.getParent()).willReturn(null);
        ApplicationContextTestUtils.closeAll((ApplicationContext)mock);
        ((ConfigurableApplicationContext)Mockito.verify((Object)mock)).getParent();
        ((ConfigurableApplicationContext)Mockito.verify((Object)mock)).close();
        ((ConfigurableApplicationContext)Mockito.verify((Object)parent)).getParent();
        ((ConfigurableApplicationContext)Mockito.verify((Object)parent)).close();
    }
}

