/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.springframework.boot.test.web.SpringBootTestRandomPortEnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.mock.env.MockEnvironment;

public class SpringBootTestRandomPortEnvironmentPostProcessorTests {
    private SpringBootTestRandomPortEnvironmentPostProcessor postProcessor = new SpringBootTestRandomPortEnvironmentPostProcessor();
    private MockEnvironment environment;
    private MutablePropertySources propertySources;

    @Before
    public void setup() {
        this.environment = new MockEnvironment();
        this.propertySources = this.environment.getPropertySources();
    }

    @Test
    public void postProcessWhenServerAndManagementPortIsZeroInTestPropertySource() {
        this.addTestPropertySource("0", "0");
        this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null);
        Assertions.assertThat((String)this.environment.getProperty("server.port")).isEqualTo((Object)"0");
        Assertions.assertThat((String)this.environment.getProperty("management.server.port")).isEqualTo((Object)"0");
    }

    @Test
    public void postProcessWhenServerPortAndManagementPortIsZeroInDifferentPropertySources() {
        this.addTestPropertySource("0", null);
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("management.server.port", "0");
        this.propertySources.addLast((PropertySource)new MapPropertySource("other", source));
        this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null);
        Assertions.assertThat((String)this.environment.getProperty("server.port")).isEqualTo((Object)"0");
        Assertions.assertThat((String)this.environment.getProperty("management.server.port")).isEqualTo((Object)"0");
    }

    @Test
    public void postProcessWhenTestServerAndTestManagementPortAreNonZero() {
        this.addTestPropertySource("8080", "8081");
        this.environment.setProperty("server.port", "8080");
        this.environment.setProperty("management.server.port", "8081");
        this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null);
        Assertions.assertThat((String)this.environment.getProperty("server.port")).isEqualTo((Object)"8080");
        Assertions.assertThat((String)this.environment.getProperty("management.server.port")).isEqualTo((Object)"8081");
    }

    @Test
    public void postProcessWhenTestServerPortIsZeroAndTestManagementPortIsNotNull() {
        this.addTestPropertySource("0", "8080");
        this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null);
        Assertions.assertThat((String)this.environment.getProperty("server.port")).isEqualTo((Object)"0");
        Assertions.assertThat((String)this.environment.getProperty("management.server.port")).isEqualTo((Object)"8080");
    }

    @Test
    public void postProcessWhenTestServerPortIsZeroAndManagementPortIsNull() {
        this.addTestPropertySource("0", null);
        this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null);
        Assertions.assertThat((String)this.environment.getProperty("server.port")).isEqualTo((Object)"0");
        Assertions.assertThat((String)this.environment.getProperty("management.server.port")).isNull();
    }

    @Test
    public void postProcessWhenTestServerPortIsZeroAndManagementPortIsNotNullAndSameInProduction() {
        this.addTestPropertySource("0", null);
        HashMap<String, String> other = new HashMap<String, String>();
        other.put("server.port", "8081");
        other.put("management.server.port", "8081");
        MapPropertySource otherSource = new MapPropertySource("other", other);
        this.propertySources.addLast((PropertySource)otherSource);
        this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null);
        Assertions.assertThat((String)this.environment.getProperty("server.port")).isEqualTo((Object)"0");
        Assertions.assertThat((String)this.environment.getProperty("management.server.port")).isEqualTo((Object)"");
    }

    @Test
    public void postProcessWhenTestServerPortIsZeroAndManagementPortIsNotNullAndDefaultSameInProduction() {
        this.addTestPropertySource("0", null);
        this.propertySources.addLast((PropertySource)new MapPropertySource("other", Collections.singletonMap("management.server.port", "8080")));
        this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null);
        Assertions.assertThat((String)this.environment.getProperty("server.port")).isEqualTo((Object)"0");
        Assertions.assertThat((String)this.environment.getProperty("management.server.port")).isEqualTo((Object)"");
    }

    @Test
    public void postProcessWhenTestServerPortIsZeroAndManagementPortIsNotNullAndDifferentInProduction() {
        this.addTestPropertySource("0", null);
        this.propertySources.addLast((PropertySource)new MapPropertySource("other", Collections.singletonMap("management.server.port", "8081")));
        this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null);
        Assertions.assertThat((String)this.environment.getProperty("server.port")).isEqualTo((Object)"0");
        Assertions.assertThat((String)this.environment.getProperty("management.server.port")).isEqualTo((Object)"0");
    }

    @Test
    public void postProcessWhenTestServerPortIsZeroAndManagementPortMinusOne() {
        this.addTestPropertySource("0", null);
        this.propertySources.addLast((PropertySource)new MapPropertySource("other", Collections.singletonMap("management.server.port", "-1")));
        this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null);
        Assertions.assertThat((String)this.environment.getProperty("server.port")).isEqualTo((Object)"0");
        Assertions.assertThat((String)this.environment.getProperty("management.server.port")).isEqualTo((Object)"-1");
    }

    @Test
    public void postProcessWhenTestServerPortIsZeroAndManagementPortIsAnInteger() {
        this.addTestPropertySource("0", null);
        this.propertySources.addLast((PropertySource)new MapPropertySource("other", Collections.singletonMap("management.server.port", 8081)));
        this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null);
        Assertions.assertThat((String)this.environment.getProperty("server.port")).isEqualTo((Object)"0");
        Assertions.assertThat((String)this.environment.getProperty("management.server.port")).isEqualTo((Object)"0");
    }

    @Test
    public void postProcessWhenManagementServerPortPlaceholderPresentShouldResolvePlaceholder() {
        this.addTestPropertySource("0", null);
        MapPropertySource testPropertySource = (MapPropertySource)this.propertySources.get("Inlined Test Properties");
        ((Map)testPropertySource.getSource()).put("port", "9090");
        this.propertySources.addLast((PropertySource)new MapPropertySource("other", Collections.singletonMap("management.server.port", "${port}")));
        this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null);
        Assertions.assertThat((String)this.environment.getProperty("server.port")).isEqualTo((Object)"0");
        Assertions.assertThat((String)this.environment.getProperty("management.server.port")).isEqualTo((Object)"0");
    }

    @Test
    public void postProcessWhenManagementServerPortPlaceholderAbsentShouldFail() {
        this.addTestPropertySource("0", null);
        this.propertySources.addLast((PropertySource)new MapPropertySource("other", Collections.singletonMap("management.server.port", "${port}")));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null)).withMessage("Could not resolve placeholder 'port' in value \"${port}\"");
    }

    @Test
    public void postProcessWhenServerPortPlaceholderPresentShouldResolvePlaceholder() {
        this.addTestPropertySource("0", null);
        MapPropertySource testPropertySource = (MapPropertySource)this.propertySources.get("Inlined Test Properties");
        ((Map)testPropertySource.getSource()).put("port", "8080");
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("server.port", "${port}");
        source.put("management.server.port", "9090");
        this.propertySources.addLast((PropertySource)new MapPropertySource("other", source));
        this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null);
        Assertions.assertThat((String)this.environment.getProperty("server.port")).isEqualTo((Object)"0");
        Assertions.assertThat((String)this.environment.getProperty("management.server.port")).isEqualTo((Object)"0");
    }

    @Test
    public void postProcessWhenServerPortPlaceholderAbsentShouldFail() {
        this.addTestPropertySource("0", null);
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("server.port", "${port}");
        source.put("management.server.port", "9090");
        this.propertySources.addLast((PropertySource)new MapPropertySource("other", source));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.postProcessor.postProcessEnvironment((ConfigurableEnvironment)this.environment, null)).withMessage("Could not resolve placeholder 'port' in value \"${port}\"");
    }

    private void addTestPropertySource(String serverPort, String managementPort) {
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("server.port", serverPort);
        source.put("management.server.port", managementPort);
        MapPropertySource inlineTestSource = new MapPropertySource("Inlined Test Properties", source);
        this.propertySources.addFirst((PropertySource)inlineTestSource);
    }
}

