/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.client.TestRestTemplateContextCustomizer;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.test.context.MergedContextConfiguration;

public class TestRestTemplateContextCustomizerTests {
    @Test
    public void whenContextIsNotABeanDefinitionRegistryTestRestTemplateIsRegistered() {
        ((ApplicationContextRunner)new ApplicationContextRunner(() -> new TestApplicationContext()).withInitializer(context -> {
            MergedContextConfiguration configuration = (MergedContextConfiguration)Mockito.mock(MergedContextConfiguration.class);
            BDDMockito.given((Object)configuration.getTestClass()).willReturn(TestClass.class);
            new TestRestTemplateContextCustomizer().customizeContext(context, configuration);
        })).run(context -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(TestRestTemplate.class));
    }

    private static class TestApplicationContext
    extends AbstractApplicationContext {
        private final ConfigurableListableBeanFactory beanFactory = new DefaultListableBeanFactory();

        private TestApplicationContext() {
        }

        protected void refreshBeanFactory() throws BeansException, IllegalStateException {
        }

        protected void closeBeanFactory() {
        }

        public ConfigurableListableBeanFactory getBeanFactory() throws IllegalStateException {
            return this.beanFactory;
        }
    }

    @SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    static class TestClass {
        TestClass() {
        }
    }
}

