/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.reactive.server;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.reactive.server.NoWebTestClientBeanChecker;
import org.springframework.boot.web.embedded.tomcat.TomcatReactiveWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.reactive.server.WebTestClient;
import reactor.core.publisher.Mono;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.main.web-application-type=reactive"})
@DirtiesContext
@RunWith(value=SpringRunner.class)
public class WebTestClientContextCustomizerIntegrationTests {
    @Autowired
    private WebTestClient webTestClient;

    @Test
    public void test() {
        this.webTestClient.get().uri("/", new Object[0]).exchange().expectBody(String.class).isEqualTo((Object)"hello");
    }

    static class TestHandler
    implements HttpHandler {
        private static final DefaultDataBufferFactory factory = new DefaultDataBufferFactory();

        TestHandler() {
        }

        public Mono<Void> handle(ServerHttpRequest request, ServerHttpResponse response) {
            response.setStatusCode(HttpStatus.OK);
            return response.writeWith((Publisher)Mono.just((Object)factory.wrap("hello".getBytes())));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={TestHandler.class, NoWebTestClientBeanChecker.class})
    static class TestConfig {
        TestConfig() {
        }

        @Bean
        public TomcatReactiveWebServerFactory webServerFactory() {
            return new TomcatReactiveWebServerFactory(0);
        }
    }
}

