/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.test.context.AnnotatedClassFinder;
import org.springframework.boot.test.context.example.ExampleConfig;
import org.springframework.boot.test.context.example.scan.Example;

class AnnotatedClassFinderTests {
    private AnnotatedClassFinder finder = new AnnotatedClassFinder(SpringBootConfiguration.class);

    AnnotatedClassFinderTests() {
    }

    @Test
    void findFromClassWhenSourceIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.finder.findFromClass((Class)null)).withMessageContaining("Source must not be null");
    }

    @Test
    void findFromPackageWhenSourceIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.finder.findFromPackage((String)null)).withMessageContaining("Source must not be null");
    }

    @Test
    void findFromPackageWhenNoConfigurationFoundShouldReturnNull() {
        Class config = this.finder.findFromPackage("org.springframework.boot");
        Assertions.assertThat((Class)config).isNull();
    }

    @Test
    void findFromClassWhenConfigurationIsFoundShouldReturnConfiguration() {
        Class config = this.finder.findFromClass(Example.class);
        Assertions.assertThat((Class)config).isEqualTo(ExampleConfig.class);
    }

    @Test
    void findFromPackageWhenConfigurationIsFoundShouldReturnConfiguration() {
        Class config = this.finder.findFromPackage("org.springframework.boot.test.context.example.scan");
        Assertions.assertThat((Class)config).isEqualTo(ExampleConfig.class);
    }
}

