/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.FilteredClassLoader;
import org.springframework.core.io.ClassPathResource;

class FilteredClassLoaderTests {
    static ClassPathResource TEST_RESOURCE = new ClassPathResource("org/springframework/boot/test/context/FilteredClassLoaderTestsResource.txt");

    FilteredClassLoaderTests() {
    }

    @Test
    void loadClassWhenFilteredOnPackageShouldThrowClassNotFound() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new String[]{FilteredClassLoaderTests.class.getPackage().getName()});){
            Assertions.assertThatExceptionOfType(ClassNotFoundException.class).isThrownBy(() -> classLoader.loadClass(this.getClass().getName()));
        }
    }

    @Test
    void loadClassWhenFilteredOnClassShouldThrowClassNotFound() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new Class[]{FilteredClassLoaderTests.class});){
            Assertions.assertThatExceptionOfType(ClassNotFoundException.class).isThrownBy(() -> classLoader.loadClass(this.getClass().getName()));
        }
    }

    @Test
    void loadClassWhenNotFilteredShouldLoadClass() throws Exception {
        FilteredClassLoader classLoader = new FilteredClassLoader(new Predicate[]{className -> false});
        Class loaded = classLoader.loadClass(this.getClass().getName());
        Assertions.assertThat((String)loaded.getName()).isEqualTo(this.getClass().getName());
        classLoader.close();
    }

    @Test
    void loadResourceWhenFilteredOnResourceShouldReturnNotFound() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new ClassPathResource[]{TEST_RESOURCE});){
            URL loaded = classLoader.getResource(TEST_RESOURCE.getPath());
            Assertions.assertThat((URL)loaded).isNull();
        }
    }

    @Test
    void loadResourceWhenNotFilteredShouldLoadResource() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new Predicate[]{resourceName -> false});){
            URL loaded = classLoader.getResource(TEST_RESOURCE.getPath());
            Assertions.assertThat((URL)loaded).isNotNull();
        }
    }

    @Test
    void loadResourcesWhenFilteredOnResourceShouldReturnNotFound() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new ClassPathResource[]{TEST_RESOURCE});){
            Enumeration loaded = classLoader.getResources(TEST_RESOURCE.getPath());
            Assertions.assertThat((boolean)loaded.hasMoreElements()).isFalse();
        }
    }

    @Test
    void loadResourcesWhenNotFilteredShouldLoadResource() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new Predicate[]{resourceName -> false});){
            Enumeration loaded = classLoader.getResources(TEST_RESOURCE.getPath());
            Assertions.assertThat((boolean)loaded.hasMoreElements()).isTrue();
        }
    }

    @Test
    void loadResourceAsStreamWhenFilteredOnResourceShouldReturnNotFound() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new ClassPathResource[]{TEST_RESOURCE});){
            InputStream loaded = classLoader.getResourceAsStream(TEST_RESOURCE.getPath());
            Assertions.assertThat((InputStream)loaded).isNull();
        }
    }

    @Test
    void loadResourceAsStreamWhenNotFilteredShouldLoadResource() throws Exception {
        try (FilteredClassLoader classLoader = new FilteredClassLoader(new Predicate[]{resourceName -> false});){
            InputStream loaded = classLoader.getResourceAsStream(TEST_RESOURCE.getPath());
            Assertions.assertThat((InputStream)loaded).isNotNull();
        }
    }
}

