/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@Import(value={ImportedBean.class})
class ImportsContextCustomizerFactoryIntegrationTests {
    @Autowired
    private ApplicationContext context;
    @Autowired
    private ImportedBean bean;

    ImportsContextCustomizerFactoryIntegrationTests() {
    }

    @Test
    void beanWasImported() {
        Assertions.assertThat((Object)this.bean).isNotNull();
    }

    @Test
    void testItselfIsNotABean() {
        Assertions.assertThatExceptionOfType(NoSuchBeanDefinitionException.class).isThrownBy(() -> {
            ImportsContextCustomizerFactoryIntegrationTests cfr_ignored_0 = (ImportsContextCustomizerFactoryIntegrationTests)this.context.getBean(this.getClass());
        });
    }

    @Component
    static class ImportedBean {
        ImportedBean() {
        }
    }
}

