/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import javax.servlet.ServletContext;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootContextLoader;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@ExtendWith(value={SpringExtension.class})
@DirtiesContext
@ContextConfiguration(loader=SpringBootContextLoader.class)
@WebAppConfiguration
class SpringBootContextLoaderMockMvcTests {
    @Autowired
    private WebApplicationContext context;
    @Autowired
    private ServletContext servletContext;
    private MockMvc mvc;

    SpringBootContextLoaderMockMvcTests() {
    }

    @BeforeEach
    void setUp() {
        this.mvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).build();
    }

    @Test
    void testMockHttpEndpoint() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("Hello World"));
    }

    @Test
    void validateWebApplicationContextIsSet() {
        Assertions.assertThat((Object)this.context).isSameAs((Object)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext));
    }

    @Configuration(proxyBeanMethods=false)
    @EnableWebMvc
    @RestController
    static class Config {
        Config() {
        }

        @RequestMapping(value={"/"})
        String home() {
            return "Hello World";
        }
    }
}

