/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

@SpringBootTest(properties={"spring.config.name=custom-config-name"})
class SpringBootTestCustomConfigNameTests {
    @Value(value="${test.foo}")
    private String foo;

    SpringBootTestCustomConfigNameTests() {
    }

    @Test
    void propertyIsLoadedFromConfigFileWithCustomName() {
        Assertions.assertThat((String)this.foo).isEqualTo("bar");
    }

    @Configuration(proxyBeanMethods=false)
    static class TestConfiguration {
        TestConfiguration() {
        }

        PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
            return new PropertySourcesPlaceholderConfigurer();
        }
    }
}

