/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.AbstractSpringBootTestEmbeddedReactiveWebEnvironmentTests;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.config.EnableWebFlux;

@DirtiesContext
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.main.web-application-type=reactive", "value=123"})
class SpringBootTestReactiveWebEnvironmentUserDefinedTestRestTemplateTests
extends AbstractSpringBootTestEmbeddedReactiveWebEnvironmentTests {
    SpringBootTestReactiveWebEnvironmentUserDefinedTestRestTemplateTests() {
    }

    @Test
    void restTemplateIsUserDefined() {
        Assertions.assertThat((Object)this.getContext().getBean("testRestTemplate")).isInstanceOf(RestTemplate.class);
    }

    @Configuration(proxyBeanMethods=false)
    @EnableWebFlux
    @RestController
    static class Config
    extends AbstractSpringBootTestEmbeddedReactiveWebEnvironmentTests.AbstractConfig {
        Config() {
        }

        @Bean
        RestTemplate testRestTemplate() {
            return new RestTemplate();
        }
    }
}

