/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.AbstractSpringBootTestWebServerWebEnvironmentTests;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@DirtiesContext
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"value=123"})
class SpringBootTestWebEnvironmentRandomPortTests
extends AbstractSpringBootTestWebServerWebEnvironmentTests {
    SpringBootTestWebEnvironmentRandomPortTests() {
    }

    @Test
    void testRestTemplateShouldUseBuilder() {
        Assertions.assertThat((List)this.getRestTemplate().getRestTemplate().getMessageConverters()).hasAtLeastOneElementOfType(MyConverter.class);
    }

    static class MyConverter
    extends StringHttpMessageConverter {
        MyConverter() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableWebMvc
    @RestController
    static class Config
    extends AbstractSpringBootTestWebServerWebEnvironmentTests.AbstractConfig {
        Config() {
        }

        @Bean
        RestTemplateBuilder restTemplateBuilder() {
            return new RestTemplateBuilder(new RestTemplateCustomizer[0]).additionalMessageConverters(new HttpMessageConverter[]{new MyConverter()});
        }
    }
}

