/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.annotation.DirtiesContext;

@DirtiesContext
@SpringBootTest(classes={Config.class})
class SpringBootTestWithClassesIntegrationTests {
    @Autowired
    private ApplicationContext context;

    SpringBootTestWithClassesIntegrationTests() {
    }

    @Test
    void injectsOnlyConfig() {
        Assertions.assertThat((Object)this.context.getBean(Config.class)).isNotNull();
        Assertions.assertThatExceptionOfType(NoSuchBeanDefinitionException.class).isThrownBy(() -> {
            AdditionalConfig cfr_ignored_0 = (AdditionalConfig)this.context.getBean(AdditionalConfig.class);
        });
    }

    @Configuration(proxyBeanMethods=false)
    static class AdditionalConfig {
        AdditionalConfig() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class Config {
        Config() {
        }
    }
}

