/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.assertj;

import java.util.function.Supplier;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.assertj.ApplicationContextAssertProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

class ApplicationContextAssertProviderTests {
    @Mock
    private ConfigurableApplicationContext mockContext;
    private RuntimeException startupFailure;
    private Supplier<ApplicationContext> mockContextSupplier;
    private Supplier<ApplicationContext> startupFailureSupplier;

    ApplicationContextAssertProviderTests() {
    }

    @BeforeEach
    void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.startupFailure = new RuntimeException();
        this.mockContextSupplier = () -> this.mockContext;
        this.startupFailureSupplier = () -> {
            throw this.startupFailure;
        };
    }

    @Test
    void getWhenTypeIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> ApplicationContextAssertProvider.get(null, ApplicationContext.class, this.mockContextSupplier)).withMessageContaining("Type must not be null");
    }

    @Test
    void getWhenTypeIsClassShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> ApplicationContextAssertProvider.get(null, ApplicationContext.class, this.mockContextSupplier)).withMessageContaining("Type must not be null");
    }

    @Test
    void getWhenContextTypeIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            TestAssertProviderApplicationContextClass cfr_ignored_0 = (TestAssertProviderApplicationContextClass)ApplicationContextAssertProvider.get(TestAssertProviderApplicationContextClass.class, ApplicationContext.class, this.mockContextSupplier);
        }).withMessageContaining("Type must be an interface");
    }

    @Test
    void getWhenContextTypeIsClassShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            TestAssertProviderApplicationContext cfr_ignored_0 = (TestAssertProviderApplicationContext)ApplicationContextAssertProvider.get(TestAssertProviderApplicationContext.class, null, this.mockContextSupplier);
        }).withMessageContaining("ContextType must not be null");
    }

    @Test
    void getWhenSupplierIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            TestAssertProviderApplicationContext cfr_ignored_0 = (TestAssertProviderApplicationContext)ApplicationContextAssertProvider.get(TestAssertProviderApplicationContext.class, StaticApplicationContext.class, this.mockContextSupplier);
        }).withMessageContaining("ContextType must be an interface");
    }

    @Test
    void getWhenContextStartsShouldReturnProxyThatCallsRealMethods() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.mockContextSupplier);
        Assertions.assertThat(context).isNotNull();
        context.getBean("foo");
        ((ConfigurableApplicationContext)Mockito.verify((Object)this.mockContext)).getBean("foo");
    }

    @Test
    void getWhenContextFailsShouldReturnProxyThatThrowsExceptions() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.startupFailureSupplier);
        Assertions.assertThat(context).isNotNull();
        Assertions.assertThatIllegalStateException().isThrownBy(() -> context.getBean("foo")).withCause((Throwable)this.startupFailure).withMessageContaining("failed to start");
    }

    @Test
    void getSourceContextWhenContextStartsShouldReturnSourceContext() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.mockContextSupplier);
        Assertions.assertThat((Object)context.getSourceApplicationContext()).isSameAs((Object)this.mockContext);
    }

    @Test
    void getSourceContextWhenContextFailsShouldThrowException() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.startupFailureSupplier);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> context.getSourceApplicationContext()).withCause((Throwable)this.startupFailure).withMessageContaining("failed to start");
    }

    @Test
    void getSourceContextOfTypeWhenContextStartsShouldReturnSourceContext() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.mockContextSupplier);
        Assertions.assertThat((Object)context.getSourceApplicationContext(ApplicationContext.class)).isSameAs((Object)this.mockContext);
    }

    @Test
    void getSourceContextOfTypeWhenContextFailsToStartShouldThrowException() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.startupFailureSupplier);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> context.getSourceApplicationContext(ApplicationContext.class)).withCause((Throwable)this.startupFailure).withMessageContaining("failed to start");
    }

    @Test
    void getStartupFailureWhenContextStartsShouldReturnNull() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.mockContextSupplier);
        Assertions.assertThat((Throwable)context.getStartupFailure()).isNull();
    }

    @Test
    void getStartupFailureWhenContextFailsToStartShouldReturnException() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.startupFailureSupplier);
        Assertions.assertThat((Throwable)context.getStartupFailure()).isEqualTo((Object)this.startupFailure);
    }

    @Test
    void assertThatWhenContextStartsShouldReturnAssertions() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.mockContextSupplier);
        ApplicationContextAssert contextAssert = (ApplicationContextAssert)Assertions.assertThat(context);
        Assertions.assertThat((Object)contextAssert.getApplicationContext()).isSameAs(context);
        Assertions.assertThat((Throwable)contextAssert.getStartupFailure()).isNull();
    }

    @Test
    void assertThatWhenContextFailsShouldReturnAssertions() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.startupFailureSupplier);
        ApplicationContextAssert contextAssert = (ApplicationContextAssert)Assertions.assertThat(context);
        Assertions.assertThat((Object)contextAssert.getApplicationContext()).isSameAs(context);
        Assertions.assertThat((Throwable)contextAssert.getStartupFailure()).isSameAs((Object)this.startupFailure);
    }

    @Test
    void toStringWhenContextStartsShouldReturnSimpleString() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.mockContextSupplier);
        ((AbstractStringAssert)Assertions.assertThat((String)context.toString()).startsWith((CharSequence)"Started application [ConfigurableApplicationContext.MockitoMock")).endsWith((CharSequence)"id = [null], applicationName = [null], beanDefinitionCount = 0]");
    }

    @Test
    void toStringWhenContextFailsToStartShouldReturnSimpleString() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.startupFailureSupplier);
        Assertions.assertThat((String)context.toString()).isEqualTo("Unstarted application context org.springframework.context.ApplicationContext[startupFailure=java.lang.RuntimeException]");
    }

    @Test
    void closeShouldCloseContext() {
        ApplicationContextAssertProvider<ApplicationContext> context = this.get(this.mockContextSupplier);
        context.close();
        ((ConfigurableApplicationContext)Mockito.verify((Object)this.mockContext)).close();
    }

    private ApplicationContextAssertProvider<ApplicationContext> get(Supplier<ApplicationContext> contextSupplier) {
        return ApplicationContextAssertProvider.get(TestAssertProviderApplicationContext.class, ApplicationContext.class, contextSupplier);
    }

    static abstract class TestAssertProviderApplicationContextClass
    implements TestAssertProviderApplicationContext {
        TestAssertProviderApplicationContextClass() {
        }
    }

    static interface TestAssertProviderApplicationContext
    extends ApplicationContextAssertProvider<ApplicationContext> {
    }
}

