/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.bootstrap;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.SpringBootTestContextBootstrapper;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.web.WebAppConfiguration;

class SpringBootTestContextBootstrapperTests {
    SpringBootTestContextBootstrapperTests() {
    }

    @Test
    void springBootTestWithANonMockWebEnvironmentAndWebAppConfigurationFailsFast() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.buildTestContext(SpringBootTestNonMockWebEnvironmentAndWebAppConfiguration.class)).withMessageContaining("@WebAppConfiguration should only be used with @SpringBootTest when @SpringBootTest is configured with a mock web environment. Please remove @WebAppConfiguration or reconfigure @SpringBootTest.");
    }

    @Test
    void springBootTestWithAMockWebEnvironmentCanBeUsedWithWebAppConfiguration() {
        this.buildTestContext(SpringBootTestMockWebEnvironmentAndWebAppConfiguration.class);
    }

    private void buildTestContext(Class<?> testClass) {
        SpringBootTestContextBootstrapper bootstrapper = new SpringBootTestContextBootstrapper();
        BootstrapContext bootstrapContext = (BootstrapContext)Mockito.mock(BootstrapContext.class);
        bootstrapper.setBootstrapContext(bootstrapContext);
        BDDMockito.given((Object)bootstrapContext.getTestClass()).willReturn(testClass);
        CacheAwareContextLoaderDelegate contextLoaderDelegate = (CacheAwareContextLoaderDelegate)Mockito.mock(CacheAwareContextLoaderDelegate.class);
        BDDMockito.given((Object)bootstrapContext.getCacheAwareContextLoaderDelegate()).willReturn((Object)contextLoaderDelegate);
        bootstrapper.buildTestContext();
    }

    @SpringBootTest
    @WebAppConfiguration
    static class SpringBootTestMockWebEnvironmentAndWebAppConfiguration {
        SpringBootTestMockWebEnvironmentAndWebAppConfiguration() {
        }
    }

    @SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    @WebAppConfiguration
    static class SpringBootTestNonMockWebEnvironmentAndWebAppConfiguration {
        SpringBootTestNonMockWebEnvironmentAndWebAppConfiguration() {
        }
    }
}

