/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.springframework.boot.test.json.AbstractJsonMarshalTester;
import org.springframework.boot.test.json.ExampleObject;
import org.springframework.boot.test.json.JsonContent;
import org.springframework.boot.test.json.JsonContentAssert;
import org.springframework.boot.test.json.ObjectContentAssert;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ReflectionUtils;

abstract class AbstractJsonMarshalTesterTests {
    private static final String JSON = "{\"name\":\"Spring\",\"age\":123}";
    private static final String MAP_JSON = "{\"a\":{\"name\":\"Spring\",\"age\":123}}";
    private static final String ARRAY_JSON = "[{\"name\":\"Spring\",\"age\":123}]";
    private static final ExampleObject OBJECT = AbstractJsonMarshalTesterTests.createExampleObject("Spring", 123);
    private static final ResolvableType TYPE = ResolvableType.forClass(ExampleObject.class);

    AbstractJsonMarshalTesterTests() {
    }

    @Test
    void writeShouldReturnJsonContent() throws Exception {
        JsonContent content = this.createTester(TYPE).write((Object)OBJECT);
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)content)).isEqualToJson((CharSequence)JSON);
    }

    @Test
    void writeListShouldReturnJsonContent() throws Exception {
        ResolvableType type = ResolvableTypes.get("listOfExampleObject");
        List<ExampleObject> value = Collections.singletonList(OBJECT);
        JsonContent content = this.createTester(type).write(value);
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)content)).isEqualToJson((CharSequence)ARRAY_JSON);
    }

    @Test
    void writeArrayShouldReturnJsonContent() throws Exception {
        ResolvableType type = ResolvableTypes.get("arrayOfExampleObject");
        ExampleObject[] value = new ExampleObject[]{OBJECT};
        JsonContent content = this.createTester(type).write((Object)value);
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)content)).isEqualToJson((CharSequence)ARRAY_JSON);
    }

    @Test
    void writeMapShouldReturnJsonContent() throws Exception {
        ResolvableType type = ResolvableTypes.get("mapOfExampleObject");
        LinkedHashMap<String, ExampleObject> value = new LinkedHashMap<String, ExampleObject>();
        value.put("a", OBJECT);
        JsonContent content = this.createTester(type).write(value);
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)content)).isEqualToJson((CharSequence)MAP_JSON);
    }

    @Test
    void createWhenResourceLoadClassIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.createTester(null, ResolvableType.forClass(ExampleObject.class))).withMessageContaining("ResourceLoadClass must not be null");
    }

    @Test
    void createWhenTypeIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.createTester(this.getClass(), null)).withMessageContaining("Type must not be null");
    }

    @Test
    void parseBytesShouldReturnObject() throws Exception {
        AbstractJsonMarshalTester<Object> tester = this.createTester(TYPE);
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)tester.parse(JSON.getBytes()))).isEqualTo((Object)OBJECT);
    }

    @Test
    void parseStringShouldReturnObject() throws Exception {
        AbstractJsonMarshalTester<Object> tester = this.createTester(TYPE);
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)tester.parse(JSON))).isEqualTo((Object)OBJECT);
    }

    @Test
    void readResourcePathShouldReturnObject() throws Exception {
        AbstractJsonMarshalTester<Object> tester = this.createTester(TYPE);
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)tester.read("example.json"))).isEqualTo((Object)OBJECT);
    }

    @Test
    void readFileShouldReturnObject(@TempDir Path temp) throws Exception {
        File file = new File(temp.toFile(), "example.json");
        FileCopyUtils.copy((byte[])JSON.getBytes(), (File)file);
        AbstractJsonMarshalTester<Object> tester = this.createTester(TYPE);
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)tester.read(file))).isEqualTo((Object)OBJECT);
    }

    @Test
    void readInputStreamShouldReturnObject() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(JSON.getBytes());
        AbstractJsonMarshalTester<Object> tester = this.createTester(TYPE);
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)tester.read((InputStream)stream))).isEqualTo((Object)OBJECT);
    }

    @Test
    void readResourceShouldReturnObject() throws Exception {
        ByteArrayResource resource = new ByteArrayResource(JSON.getBytes());
        AbstractJsonMarshalTester<Object> tester = this.createTester(TYPE);
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)tester.read((Resource)resource))).isEqualTo((Object)OBJECT);
    }

    @Test
    void readReaderShouldReturnObject() throws Exception {
        StringReader reader = new StringReader(JSON);
        AbstractJsonMarshalTester<Object> tester = this.createTester(TYPE);
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)tester.read((Reader)reader))).isEqualTo((Object)OBJECT);
    }

    @Test
    void parseListShouldReturnContent() throws Exception {
        ResolvableType type = ResolvableTypes.get("listOfExampleObject");
        AbstractJsonMarshalTester<Object> tester = this.createTester(type);
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)tester.parse(ARRAY_JSON))).asList().containsOnly(new Object[]{OBJECT});
    }

    @Test
    void parseArrayShouldReturnContent() throws Exception {
        ResolvableType type = ResolvableTypes.get("arrayOfExampleObject");
        AbstractJsonMarshalTester<Object> tester = this.createTester(type);
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)tester.parse(ARRAY_JSON))).asArray().containsOnly(new Object[]{OBJECT});
    }

    @Test
    void parseMapShouldReturnContent() throws Exception {
        ResolvableType type = ResolvableTypes.get("mapOfExampleObject");
        AbstractJsonMarshalTester<Object> tester = this.createTester(type);
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)tester.parse(MAP_JSON))).asMap().containsEntry((Object)"a", (Object)OBJECT);
    }

    protected static final ExampleObject createExampleObject(String name, int age) {
        ExampleObject exampleObject = new ExampleObject();
        exampleObject.setName(name);
        exampleObject.setAge(age);
        return exampleObject;
    }

    protected final AbstractJsonMarshalTester<Object> createTester(ResolvableType type) {
        return this.createTester(AbstractJsonMarshalTesterTests.class, type);
    }

    protected abstract AbstractJsonMarshalTester<Object> createTester(Class<?> var1, ResolvableType var2);

    static class ResolvableTypes {
        public List<ExampleObject> listOfExampleObject;
        public ExampleObject[] arrayOfExampleObject;
        public Map<String, ExampleObject> mapOfExampleObject;

        ResolvableTypes() {
        }

        static ResolvableType get(String name) {
            Field field = ReflectionUtils.findField(ResolvableTypes.class, (String)name);
            return ResolvableType.forField((Field)field);
        }
    }
}

