/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.springframework.boot.test.json.BasicJsonTester;
import org.springframework.boot.test.json.JsonContentAssert;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

class BasicJsonTesterTests {
    private static final String JSON = "{\"spring\":[\"boot\",\"framework\"]}";
    private BasicJsonTester json = new BasicJsonTester(this.getClass());

    BasicJsonTesterTests() {
    }

    @Test
    void createWhenResourceLoadClassIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new BasicJsonTester(null)).withMessageContaining("ResourceLoadClass must not be null");
    }

    @Test
    void fromJsonStringShouldReturnJsonContent() {
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.json.from((CharSequence)JSON))).isEqualToJson((CharSequence)"source.json");
    }

    @Test
    void fromResourceStringShouldReturnJsonContent() {
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.json.from((CharSequence)"source.json"))).isEqualToJson((CharSequence)JSON);
    }

    @Test
    void fromResourceStringWithClassShouldReturnJsonContent() {
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.json.from("source.json", this.getClass()))).isEqualToJson((CharSequence)JSON);
    }

    @Test
    void fromByteArrayShouldReturnJsonContent() {
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.json.from(JSON.getBytes()))).isEqualToJson((CharSequence)"source.json");
    }

    @Test
    void fromFileShouldReturnJsonContent(@TempDir Path temp) throws Exception {
        File file = new File(temp.toFile(), "file.json");
        FileCopyUtils.copy((byte[])JSON.getBytes(), (File)file);
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.json.from(file))).isEqualToJson((CharSequence)"source.json");
    }

    @Test
    void fromInputStreamShouldReturnJsonContent() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(JSON.getBytes());
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.json.from((InputStream)inputStream))).isEqualToJson((CharSequence)"source.json");
    }

    @Test
    void fromResourceShouldReturnJsonContent() {
        ByteArrayResource resource = new ByteArrayResource(JSON.getBytes());
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.json.from((Resource)resource))).isEqualToJson((CharSequence)"source.json");
    }
}

