/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import com.google.gson.Gson;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.json.ExampleObject;
import org.springframework.boot.test.json.GsonTester;
import org.springframework.boot.test.json.JsonContentAssert;
import org.springframework.boot.test.json.ObjectContentAssert;

class GsonTesterIntegrationTests {
    private GsonTester<ExampleObject> simpleJson;
    private GsonTester<List<ExampleObject>> listJson;
    private GsonTester<Map<String, Integer>> mapJson;
    private GsonTester<String> stringJson;
    private Gson gson;
    private static final String JSON = "{\"name\":\"Spring\",\"age\":123}";

    GsonTesterIntegrationTests() {
    }

    @BeforeEach
    void setup() {
        this.gson = new Gson();
        GsonTester.initFields((Object)this, (Gson)this.gson);
    }

    @Test
    void typicalTest() throws Exception {
        String example = JSON;
        Assertions.assertThat((String)((ExampleObject)this.simpleJson.parse(example).getObject()).getName()).isEqualTo("Spring");
    }

    @Test
    void typicalListTest() throws Exception {
        String example = "[{\"name\":\"Spring\",\"age\":123}]";
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)this.listJson.parse(example))).asList().hasSize(1);
        Assertions.assertThat((String)((ExampleObject)((List)this.listJson.parse(example).getObject()).get(0)).getName()).isEqualTo("Spring");
    }

    @Test
    void typicalMapTest() throws Exception {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        map.put("a", 1);
        map.put("b", 2);
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.mapJson.write(map))).extractingJsonPathNumberValue((CharSequence)"@.a", new Object[0]).isEqualTo((Object)1);
    }

    @Test
    void stringLiteral() throws Exception {
        String stringWithSpecialCharacters = "myString";
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.stringJson.write((Object)stringWithSpecialCharacters))).extractingJsonPathStringValue((CharSequence)"@", new Object[0]).isEqualTo((Object)stringWithSpecialCharacters);
    }
}

