/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.json.ExampleObject;
import org.springframework.boot.test.json.ExampleObjectWithView;
import org.springframework.boot.test.json.JacksonTester;
import org.springframework.boot.test.json.JsonContent;
import org.springframework.boot.test.json.JsonContentAssert;
import org.springframework.boot.test.json.ObjectContent;
import org.springframework.boot.test.json.ObjectContentAssert;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

class JacksonTesterIntegrationTests {
    private JacksonTester<ExampleObject> simpleJson;
    private JacksonTester<ExampleObjectWithView> jsonWithView;
    private JacksonTester<List<ExampleObject>> listJson;
    private JacksonTester<Map<String, Integer>> mapJson;
    private JacksonTester<String> stringJson;
    private ObjectMapper objectMapper;
    private static final String JSON = "{\"name\":\"Spring\",\"age\":123}";

    JacksonTesterIntegrationTests() {
    }

    @BeforeEach
    void setup() {
        this.objectMapper = new ObjectMapper();
        JacksonTester.initFields((Object)this, (ObjectMapper)this.objectMapper);
    }

    @Test
    void typicalTest() throws Exception {
        String example = JSON;
        Assertions.assertThat((String)((ExampleObject)this.simpleJson.parse(example).getObject()).getName()).isEqualTo("Spring");
    }

    @Test
    void typicalListTest() throws Exception {
        String example = "[{\"name\":\"Spring\",\"age\":123}]";
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)this.listJson.parse(example))).asList().hasSize(1);
        Assertions.assertThat((String)((ExampleObject)((List)this.listJson.parse(example).getObject()).get(0)).getName()).isEqualTo("Spring");
    }

    @Test
    void typicalMapTest() throws Exception {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        map.put("a", 1);
        map.put("b", 2);
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.mapJson.write(map))).extractingJsonPathNumberValue((CharSequence)"@.a", new Object[0]).isEqualTo((Object)1);
    }

    @Test
    void stringLiteral() throws Exception {
        String stringWithSpecialCharacters = "myString";
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.stringJson.write((Object)stringWithSpecialCharacters))).extractingJsonPathStringValue((CharSequence)"@", new Object[0]).isEqualTo((Object)stringWithSpecialCharacters);
    }

    @Test
    void parseSpecialCharactersTest() throws Exception {
        String stringWithSpecialCharacters = "\u0006\u007f";
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.stringJson.write((Object)stringWithSpecialCharacters))).extractingJsonPathStringValue((CharSequence)"@", new Object[0]).isEqualTo((Object)stringWithSpecialCharacters);
    }

    @Test
    void writeWithView() throws Exception {
        this.objectMapper.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
        ExampleObjectWithView object = new ExampleObjectWithView();
        object.setName("Spring");
        object.setAge(123);
        JsonContent content = this.jsonWithView.forView(ExampleObjectWithView.TestView.class).write((Object)object);
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)content)).extractingJsonPathStringValue((CharSequence)"@.name", new Object[0]).isEqualTo((Object)"Spring");
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)content)).doesNotHaveJsonPathValue((CharSequence)"age", new Object[0]);
    }

    @Test
    void readWithResourceAndView() throws Exception {
        this.objectMapper.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
        ByteArrayResource resource = new ByteArrayResource(JSON.getBytes());
        ObjectContent content = this.jsonWithView.forView(ExampleObjectWithView.TestView.class).read((Resource)resource);
        Assertions.assertThat((String)((ExampleObjectWithView)content.getObject()).getName()).isEqualTo("Spring");
        Assertions.assertThat((int)((ExampleObjectWithView)content.getObject()).getAge()).isEqualTo(0);
    }

    @Test
    void readWithReaderAndView() throws Exception {
        this.objectMapper.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
        StringReader reader = new StringReader(JSON);
        ObjectContent content = this.jsonWithView.forView(ExampleObjectWithView.TestView.class).read((Reader)reader);
        Assertions.assertThat((String)((ExampleObjectWithView)content.getObject()).getName()).isEqualTo("Spring");
        Assertions.assertThat((int)((ExampleObjectWithView)content.getObject()).getAge()).isEqualTo(0);
    }
}

