/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.comparator.DefaultComparator;
import org.skyscreamer.jsonassert.comparator.JSONComparator;
import org.springframework.boot.test.json.JsonContentAssert;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

class JsonContentAssertTests {
    private static final String SOURCE = JsonContentAssertTests.loadJson("source.json");
    private static final String LENIENT_SAME = JsonContentAssertTests.loadJson("lenient-same.json");
    private static final String DIFFERENT = JsonContentAssertTests.loadJson("different.json");
    private static final String TYPES = JsonContentAssertTests.loadJson("types.json");
    private static final String SIMPSONS = JsonContentAssertTests.loadJson("simpsons.json");
    private static final String NULLS = JsonContentAssertTests.loadJson("nulls.json");
    private static JSONComparator COMPARATOR = new DefaultComparator(JSONCompareMode.LENIENT);
    @TempDir
    public Path tempDir;
    private File temp;

    JsonContentAssertTests() {
    }

    @BeforeEach
    void setup() {
        this.temp = new File(this.tempDir.toFile(), "file.json");
    }

    @Test
    void isEqualToWhenStringIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)LENIENT_SAME);
    }

    @Test
    void isEqualToWhenNullActualShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(null))).isEqualTo((Object)SOURCE));
    }

    @Test
    void isEqualToWhenStringIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)DIFFERENT));
    }

    @Test
    void isEqualToWhenResourcePathIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)"lenient-same.json");
    }

    @Test
    void isEqualToWhenResourcePathIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)"different.json"));
    }

    @Test
    void isEqualToWhenBytesAreMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)LENIENT_SAME.getBytes());
    }

    @Test
    void isEqualToWhenBytesAreNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)DIFFERENT.getBytes()));
    }

    @Test
    void isEqualToWhenFileIsMatchingShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)this.createFile(LENIENT_SAME));
    }

    @Test
    void isEqualToWhenFileIsNotMatchingShouldFail() throws Exception {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)this.createFile(DIFFERENT)));
    }

    @Test
    void isEqualToWhenInputStreamIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)this.createInputStream(LENIENT_SAME));
    }

    @Test
    void isEqualToWhenInputStreamIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)this.createInputStream(DIFFERENT)));
    }

    @Test
    void isEqualToWhenResourceIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)this.createResource(LENIENT_SAME));
    }

    @Test
    void isEqualToWhenResourceIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)this.createResource(DIFFERENT)));
    }

    @Test
    void isEqualToJsonWhenStringIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)LENIENT_SAME);
    }

    @Test
    void isEqualToJsonWhenNullActualShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(null))).isEqualToJson((CharSequence)SOURCE));
    }

    @Test
    void isEqualToJsonWhenStringIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)DIFFERENT));
    }

    @Test
    void isEqualToJsonWhenResourcePathIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)"lenient-same.json");
    }

    @Test
    void isEqualToJsonWhenResourcePathIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)"different.json"));
    }

    @Test
    void isEqualToJsonWhenResourcePathAndClassIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson("lenient-same.json", this.getClass());
    }

    @Test
    void isEqualToJsonWhenResourcePathAndClassIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson("different.json", this.getClass()));
    }

    @Test
    void isEqualToJsonWhenBytesAreMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(LENIENT_SAME.getBytes());
    }

    @Test
    void isEqualToJsonWhenBytesAreNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(DIFFERENT.getBytes()));
    }

    @Test
    void isEqualToJsonWhenFileIsMatchingShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createFile(LENIENT_SAME));
    }

    @Test
    void isEqualToJsonWhenFileIsNotMatchingShouldFail() throws Exception {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createFile(DIFFERENT)));
    }

    @Test
    void isEqualToJsonWhenInputStreamIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createInputStream(LENIENT_SAME));
    }

    @Test
    void isEqualToJsonWhenInputStreamIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createInputStream(DIFFERENT)));
    }

    @Test
    void isEqualToJsonWhenResourceIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createResource(LENIENT_SAME));
    }

    @Test
    void isEqualToJsonWhenResourceIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createResource(DIFFERENT)));
    }

    @Test
    void isStrictlyEqualToJsonWhenStringIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson((CharSequence)SOURCE);
    }

    @Test
    void isStrictlyEqualToJsonWhenStringIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson((CharSequence)LENIENT_SAME));
    }

    @Test
    void isStrictlyEqualToJsonWhenResourcePathIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson((CharSequence)"source.json");
    }

    @Test
    void isStrictlyEqualToJsonWhenResourcePathIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson((CharSequence)"lenient-same.json"));
    }

    @Test
    void isStrictlyEqualToJsonWhenResourcePathAndClassIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson("source.json", this.getClass());
    }

    @Test
    void isStrictlyEqualToJsonWhenResourcePathAndClassIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson("lenient-same.json", this.getClass()));
    }

    @Test
    void isStrictlyEqualToJsonWhenBytesAreMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(SOURCE.getBytes());
    }

    @Test
    void isStrictlyEqualToJsonWhenBytesAreNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(LENIENT_SAME.getBytes()));
    }

    @Test
    void isStrictlyEqualToJsonWhenFileIsMatchingShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(this.createFile(SOURCE));
    }

    @Test
    void isStrictlyEqualToJsonWhenFileIsNotMatchingShouldFail() throws Exception {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(this.createFile(LENIENT_SAME)));
    }

    @Test
    void isStrictlyEqualToJsonWhenInputStreamIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(this.createInputStream(SOURCE));
    }

    @Test
    void isStrictlyEqualToJsonWhenInputStreamIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(this.createInputStream(LENIENT_SAME)));
    }

    @Test
    void isStrictlyEqualToJsonWhenResourceIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(this.createResource(SOURCE));
    }

    @Test
    void isStrictlyEqualToJsonWhenResourceIsNotMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(this.createResource(LENIENT_SAME)));
    }

    @Test
    void isEqualToJsonWhenStringIsMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)LENIENT_SAME, JSONCompareMode.LENIENT);
    }

    @Test
    void isEqualToJsonWhenStringIsNotMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)DIFFERENT, JSONCompareMode.LENIENT));
    }

    @Test
    void isEqualToJsonWhenResourcePathIsMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)"lenient-same.json", JSONCompareMode.LENIENT);
    }

    @Test
    void isEqualToJsonWhenResourcePathIsNotMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)"different.json", JSONCompareMode.LENIENT));
    }

    @Test
    void isEqualToJsonWhenResourcePathAndClassIsMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson("lenient-same.json", this.getClass(), JSONCompareMode.LENIENT);
    }

    @Test
    void isEqualToJsonWhenResourcePathAndClassIsNotMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson("different.json", this.getClass(), JSONCompareMode.LENIENT));
    }

    @Test
    void isEqualToJsonWhenBytesAreMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(LENIENT_SAME.getBytes(), JSONCompareMode.LENIENT);
    }

    @Test
    void isEqualToJsonWhenBytesAreNotMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(DIFFERENT.getBytes(), JSONCompareMode.LENIENT));
    }

    @Test
    void isEqualToJsonWhenFileIsMatchingAndLenientShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createFile(LENIENT_SAME), JSONCompareMode.LENIENT);
    }

    @Test
    void isEqualToJsonWhenFileIsNotMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createFile(DIFFERENT), JSONCompareMode.LENIENT));
    }

    @Test
    void isEqualToJsonWhenInputStreamIsMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createInputStream(LENIENT_SAME), JSONCompareMode.LENIENT);
    }

    @Test
    void isEqualToJsonWhenInputStreamIsNotMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createInputStream(DIFFERENT), JSONCompareMode.LENIENT));
    }

    @Test
    void isEqualToJsonWhenResourceIsMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createResource(LENIENT_SAME), JSONCompareMode.LENIENT);
    }

    @Test
    void isEqualToJsonWhenResourceIsNotMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createResource(DIFFERENT), JSONCompareMode.LENIENT));
    }

    @Test
    void isEqualToJsonWhenStringIsMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)LENIENT_SAME, COMPARATOR);
    }

    @Test
    void isEqualToJsonWhenStringIsNotMatchingAndComparatorShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)DIFFERENT, COMPARATOR));
    }

    @Test
    void isEqualToJsonWhenResourcePathIsMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)"lenient-same.json", COMPARATOR);
    }

    @Test
    void isEqualToJsonWhenResourcePathIsNotMatchingAndComparatorShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)"different.json", COMPARATOR));
    }

    @Test
    void isEqualToJsonWhenResourcePathAndClassAreMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson("lenient-same.json", this.getClass(), COMPARATOR);
    }

    @Test
    void isEqualToJsonWhenResourcePathAndClassAreNotMatchingAndComparatorShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson("different.json", this.getClass(), COMPARATOR));
    }

    @Test
    void isEqualToJsonWhenBytesAreMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(LENIENT_SAME.getBytes(), COMPARATOR);
    }

    @Test
    void isEqualToJsonWhenBytesAreNotMatchingAndComparatorShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(DIFFERENT.getBytes(), COMPARATOR));
    }

    @Test
    void isEqualToJsonWhenFileIsMatchingAndComparatorShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createFile(LENIENT_SAME), COMPARATOR);
    }

    @Test
    void isEqualToJsonWhenFileIsNotMatchingAndComparatorShouldFail() throws Exception {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createFile(DIFFERENT), COMPARATOR));
    }

    @Test
    void isEqualToJsonWhenInputStreamIsMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createInputStream(LENIENT_SAME), COMPARATOR);
    }

    @Test
    void isEqualToJsonWhenInputStreamIsNotMatchingAndComparatorShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createInputStream(DIFFERENT), COMPARATOR));
    }

    @Test
    void isEqualToJsonWhenResourceIsMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createResource(LENIENT_SAME), COMPARATOR);
    }

    @Test
    void isEqualToJsonWhenResourceIsNotMatchingAndComparatorShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createResource(DIFFERENT), COMPARATOR));
    }

    @Test
    void isNotEqualToWhenStringIsMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)LENIENT_SAME));
    }

    @Test
    void isNotEqualToWhenNullActualShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(null))).isNotEqualTo((Object)SOURCE);
    }

    @Test
    void isNotEqualToWhenStringIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)DIFFERENT);
    }

    @Test
    void isNotEqualToWhenResourcePathIsMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)"lenient-same.json"));
    }

    @Test
    void isNotEqualToWhenResourcePathIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)"different.json");
    }

    @Test
    void isNotEqualToWhenBytesAreMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)LENIENT_SAME.getBytes()));
    }

    @Test
    void isNotEqualToWhenBytesAreNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)DIFFERENT.getBytes());
    }

    @Test
    void isNotEqualToWhenFileIsMatchingShouldFail() throws Exception {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)this.createFile(LENIENT_SAME)));
    }

    @Test
    void isNotEqualToWhenFileIsNotMatchingShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)this.createFile(DIFFERENT));
    }

    @Test
    void isNotEqualToWhenInputStreamIsMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)this.createInputStream(LENIENT_SAME)));
    }

    @Test
    void isNotEqualToWhenInputStreamIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)this.createInputStream(DIFFERENT));
    }

    @Test
    void isNotEqualToWhenResourceIsMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)this.createResource(LENIENT_SAME)));
    }

    @Test
    void isNotEqualToWhenResourceIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)this.createResource(DIFFERENT));
    }

    @Test
    void isNotEqualToJsonWhenStringIsMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)LENIENT_SAME));
    }

    @Test
    void isNotEqualToJsonWhenNullActualShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(null))).isNotEqualToJson((CharSequence)SOURCE);
    }

    @Test
    void isNotEqualToJsonWhenStringIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)DIFFERENT);
    }

    @Test
    void isNotEqualToJsonWhenResourcePathIsMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)"lenient-same.json"));
    }

    @Test
    void isNotEqualToJsonWhenResourcePathIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)"different.json");
    }

    @Test
    void isNotEqualToJsonWhenResourcePathAndClassAreMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson("lenient-same.json", this.getClass()));
    }

    @Test
    void isNotEqualToJsonWhenResourcePathAndClassAreNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson("different.json", this.getClass());
    }

    @Test
    void isNotEqualToJsonWhenBytesAreMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(LENIENT_SAME.getBytes()));
    }

    @Test
    void isNotEqualToJsonWhenBytesAreNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(DIFFERENT.getBytes());
    }

    @Test
    void isNotEqualToJsonWhenFileIsMatchingShouldFail() throws Exception {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createFile(LENIENT_SAME)));
    }

    @Test
    void isNotEqualToJsonWhenFileIsNotMatchingShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createFile(DIFFERENT));
    }

    @Test
    void isNotEqualToJsonWhenInputStreamIsMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createInputStream(LENIENT_SAME)));
    }

    @Test
    void isNotEqualToJsonWhenInputStreamIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createInputStream(DIFFERENT));
    }

    @Test
    void isNotEqualToJsonWhenResourceIsMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createResource(LENIENT_SAME)));
    }

    @Test
    void isNotEqualToJsonWhenResourceIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createResource(DIFFERENT));
    }

    @Test
    void isNotStrictlyEqualToJsonWhenStringIsMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson((CharSequence)SOURCE));
    }

    @Test
    void isNotStrictlyEqualToJsonWhenStringIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson((CharSequence)LENIENT_SAME);
    }

    @Test
    void isNotStrictlyEqualToJsonWhenResourcePathIsMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson((CharSequence)"source.json"));
    }

    @Test
    void isNotStrictlyEqualToJsonWhenResourcePathIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson((CharSequence)"lenient-same.json");
    }

    @Test
    void isNotStrictlyEqualToJsonWhenResourcePathAndClassAreMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson("source.json", this.getClass()));
    }

    @Test
    void isNotStrictlyEqualToJsonWhenResourcePathAndClassAreNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson("lenient-same.json", this.getClass());
    }

    @Test
    void isNotStrictlyEqualToJsonWhenBytesAreMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(SOURCE.getBytes()));
    }

    @Test
    void isNotStrictlyEqualToJsonWhenBytesAreNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(LENIENT_SAME.getBytes());
    }

    @Test
    void isNotStrictlyEqualToJsonWhenFileIsMatchingShouldFail() throws Exception {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(this.createFile(SOURCE)));
    }

    @Test
    void isNotStrictlyEqualToJsonWhenFileIsNotMatchingShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(this.createFile(LENIENT_SAME));
    }

    @Test
    void isNotStrictlyEqualToJsonWhenInputStreamIsMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(this.createInputStream(SOURCE)));
    }

    @Test
    void isNotStrictlyEqualToJsonWhenInputStreamIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(this.createInputStream(LENIENT_SAME));
    }

    @Test
    void isNotStrictlyEqualToJsonWhenResourceIsMatchingShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(this.createResource(SOURCE)));
    }

    @Test
    void isNotStrictlyEqualToJsonWhenResourceIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(this.createResource(LENIENT_SAME));
    }

    @Test
    void isNotEqualToJsonWhenStringIsMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)LENIENT_SAME, JSONCompareMode.LENIENT));
    }

    @Test
    void isNotEqualToJsonWhenStringIsNotMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)DIFFERENT, JSONCompareMode.LENIENT);
    }

    @Test
    void isNotEqualToJsonWhenResourcePathIsMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)"lenient-same.json", JSONCompareMode.LENIENT));
    }

    @Test
    void isNotEqualToJsonWhenResourcePathIsNotMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)"different.json", JSONCompareMode.LENIENT);
    }

    @Test
    void isNotEqualToJsonWhenResourcePathAndClassAreMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson("lenient-same.json", this.getClass(), JSONCompareMode.LENIENT));
    }

    @Test
    void isNotEqualToJsonWhenResourcePathAndClassAreNotMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson("different.json", this.getClass(), JSONCompareMode.LENIENT);
    }

    @Test
    void isNotEqualToJsonWhenBytesAreMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(LENIENT_SAME.getBytes(), JSONCompareMode.LENIENT));
    }

    @Test
    void isNotEqualToJsonWhenBytesAreNotMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(DIFFERENT.getBytes(), JSONCompareMode.LENIENT);
    }

    @Test
    void isNotEqualToJsonWhenFileIsMatchingAndLenientShouldFail() throws Exception {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createFile(LENIENT_SAME), JSONCompareMode.LENIENT));
    }

    @Test
    void isNotEqualToJsonWhenFileIsNotMatchingAndLenientShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createFile(DIFFERENT), JSONCompareMode.LENIENT);
    }

    @Test
    void isNotEqualToJsonWhenInputStreamIsMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createInputStream(LENIENT_SAME), JSONCompareMode.LENIENT));
    }

    @Test
    void isNotEqualToJsonWhenInputStreamIsNotMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createInputStream(DIFFERENT), JSONCompareMode.LENIENT);
    }

    @Test
    void isNotEqualToJsonWhenResourceIsMatchingAndLenientShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createResource(LENIENT_SAME), JSONCompareMode.LENIENT));
    }

    @Test
    void isNotEqualToJsonWhenResourceIsNotMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createResource(DIFFERENT), JSONCompareMode.LENIENT);
    }

    @Test
    void isNotEqualToJsonWhenStringIsMatchingAndComparatorShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)LENIENT_SAME, COMPARATOR));
    }

    @Test
    void isNotEqualToJsonWhenStringIsNotMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)DIFFERENT, COMPARATOR);
    }

    @Test
    void isNotEqualToJsonWhenResourcePathIsMatchingAndComparatorShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)"lenient-same.json", COMPARATOR));
    }

    @Test
    void isNotEqualToJsonWhenResourcePathIsNotMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)"different.json", COMPARATOR);
    }

    @Test
    void isNotEqualToJsonWhenResourcePathAndClassAreMatchingAndComparatorShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson("lenient-same.json", this.getClass(), COMPARATOR));
    }

    @Test
    void isNotEqualToJsonWhenResourcePathAndClassAreNotMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson("different.json", this.getClass(), COMPARATOR);
    }

    @Test
    void isNotEqualToJsonWhenBytesAreMatchingAndComparatorShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(LENIENT_SAME.getBytes(), COMPARATOR));
    }

    @Test
    void isNotEqualToJsonWhenBytesAreNotMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(DIFFERENT.getBytes(), COMPARATOR);
    }

    @Test
    void isNotEqualToJsonWhenFileIsMatchingAndComparatorShouldFail() throws Exception {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createFile(LENIENT_SAME), COMPARATOR));
    }

    @Test
    void isNotEqualToJsonWhenFileIsNotMatchingAndComparatorShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createFile(DIFFERENT), COMPARATOR);
    }

    @Test
    void isNotEqualToJsonWhenInputStreamIsMatchingAndComparatorShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createInputStream(LENIENT_SAME), COMPARATOR));
    }

    @Test
    void isNotEqualToJsonWhenInputStreamIsNotMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createInputStream(DIFFERENT), COMPARATOR);
    }

    @Test
    void isNotEqualToJsonWhenResourceIsMatchingAndComparatorShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createResource(LENIENT_SAME), COMPARATOR));
    }

    @Test
    void isNotEqualToJsonWhenResourceIsNotMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createResource(DIFFERENT), COMPARATOR);
    }

    @Test
    void hasJsonPathForPresentAndNotNull() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(NULLS))).hasJsonPath((CharSequence)"valuename", new Object[0]);
    }

    @Test
    void hasJsonPathForPresentAndNull() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(NULLS))).hasJsonPath((CharSequence)"nullname", new Object[0]);
    }

    @Test
    void hasJsonPathForNotPresent() {
        String expression = "missing";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(NULLS))).hasJsonPath((CharSequence)expression, new Object[0])).withMessageContaining("No JSON path \"" + expression + "\" found");
    }

    @Test
    void hasJsonPathValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathValue((CharSequence)"$.str", new Object[0]);
    }

    @Test
    void hasJsonPathValueForAnEmptyArray() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathValue((CharSequence)"$.emptyArray", new Object[0]);
    }

    @Test
    void hasJsonPathValueForAnEmptyMap() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathValue((CharSequence)"$.emptyMap", new Object[0]);
    }

    @Test
    void hasJsonPathValueForANullValue() {
        String expression = "nullname";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(NULLS))).hasJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("No value at JSON path \"" + expression + "\"");
    }

    @Test
    void hasJsonPathValueForMissingValue() {
        String expression = "missing";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(NULLS))).hasJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("No value at JSON path \"" + expression + "\"");
    }

    @Test
    void hasJsonPathValueForIndefinitePathWithResults() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).hasJsonPathValue((CharSequence)"$.familyMembers[?(@.name == 'Bart')]", new Object[0]);
    }

    @Test
    void hasJsonPathValueForIndefinitePathWithEmptyResults() {
        String expression = "$.familyMembers[?(@.name == 'Dilbert')]";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).hasJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("No value at JSON path \"" + expression + "\"");
    }

    @Test
    void doesNotHaveJsonPathForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(NULLS))).doesNotHaveJsonPath((CharSequence)"missing", new Object[0]);
    }

    @Test
    void doesNotHaveJsonPathForNull() {
        String expression = "nullname";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(NULLS))).doesNotHaveJsonPath((CharSequence)expression, new Object[0])).withMessageContaining("Expecting no JSON path \"" + expression + "\"");
    }

    @Test
    void doesNotHaveJsonPathForPresent() {
        String expression = "valuename";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(NULLS))).doesNotHaveJsonPath((CharSequence)expression, new Object[0])).withMessageContaining("Expecting no JSON path \"" + expression + "\"");
    }

    @Test
    void doesNotHaveJsonPathValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveJsonPathValue((CharSequence)"$.bogus", new Object[0]);
    }

    @Test
    void doesNotHaveJsonPathValueForAnEmptyArray() {
        String expression = "$.emptyArray";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected no value at JSON path \"" + expression + "\" but found: []");
    }

    @Test
    void doesNotHaveJsonPathValueForAnEmptyMap() {
        String expression = "$.emptyMap";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected no value at JSON path \"" + expression + "\" but found: {}");
    }

    @Test
    void doesNotHaveJsonPathValueForIndefinitePathWithResults() {
        String expression = "$.familyMembers[?(@.name == 'Bart')]";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).doesNotHaveJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected no value at JSON path \"" + expression + "\" but found: [{\"name\":\"Bart\"}]");
    }

    @Test
    void doesNotHaveJsonPathValueForIndefinitePathWithEmptyResults() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).doesNotHaveJsonPathValue((CharSequence)"$.familyMembers[?(@.name == 'Dilbert')]", new Object[0]);
    }

    @Test
    void doesNotHaveJsonPathValueForNull() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(NULLS))).doesNotHaveJsonPathValue((CharSequence)"nullname", new Object[0]);
    }

    @Test
    void hasEmptyJsonPathValueForAnEmptyString() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasEmptyJsonPathValue((CharSequence)"$.emptyString", new Object[0]);
    }

    @Test
    void hasEmptyJsonPathValueForAnEmptyArray() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasEmptyJsonPathValue((CharSequence)"$.emptyArray", new Object[0]);
    }

    @Test
    void hasEmptyJsonPathValueForAnEmptyMap() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasEmptyJsonPathValue((CharSequence)"$.emptyMap", new Object[0]);
    }

    @Test
    void hasEmptyJsonPathValueForIndefinitePathWithEmptyResults() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).hasEmptyJsonPathValue((CharSequence)"$.familyMembers[?(@.name == 'Dilbert')]", new Object[0]);
    }

    @Test
    void hasEmptyJsonPathValueForIndefinitePathWithResults() {
        String expression = "$.familyMembers[?(@.name == 'Bart')]";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).hasEmptyJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected an empty value at JSON path \"" + expression + "\" but found: [{\"name\":\"Bart\"}]");
    }

    @Test
    void hasEmptyJsonPathValueForWhitespace() {
        String expression = "$.whitespace";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasEmptyJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected an empty value at JSON path \"" + expression + "\" but found: '    '");
    }

    @Test
    void doesNotHaveEmptyJsonPathValueForString() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)"$.str", new Object[0]);
    }

    @Test
    void doesNotHaveEmptyJsonPathValueForNumber() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)"$.num", new Object[0]);
    }

    @Test
    void doesNotHaveEmptyJsonPathValueForBoolean() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)"$.bool", new Object[0]);
    }

    @Test
    void doesNotHaveEmptyJsonPathValueForArray() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)"$.arr", new Object[0]);
    }

    @Test
    void doesNotHaveEmptyJsonPathValueForMap() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)"$.colorMap", new Object[0]);
    }

    @Test
    void doesNotHaveEmptyJsonPathValueForIndefinitePathWithResults() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).doesNotHaveEmptyJsonPathValue((CharSequence)"$.familyMembers[?(@.name == 'Bart')]", new Object[0]);
    }

    @Test
    void doesNotHaveEmptyJsonPathValueForIndefinitePathWithEmptyResults() {
        String expression = "$.familyMembers[?(@.name == 'Dilbert')]";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).doesNotHaveEmptyJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a non-empty value at JSON path \"" + expression + "\" but found: []");
    }

    @Test
    void doesNotHaveEmptyJsonPathValueForAnEmptyString() {
        String expression = "$.emptyString";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a non-empty value at JSON path \"" + expression + "\" but found: ''");
    }

    @Test
    void doesNotHaveEmptyJsonPathValueForForAnEmptyArray() {
        String expression = "$.emptyArray";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a non-empty value at JSON path \"" + expression + "\" but found: []");
    }

    @Test
    void doesNotHaveEmptyJsonPathValueForAnEmptyMap() {
        String expression = "$.emptyMap";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a non-empty value at JSON path \"" + expression + "\" but found: {}");
    }

    @Test
    void hasJsonPathStringValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathStringValue((CharSequence)"$.str", new Object[0]);
    }

    @Test
    void hasJsonPathStringValueForAnEmptyString() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathStringValue((CharSequence)"$.emptyString", new Object[0]);
    }

    @Test
    void hasJsonPathStringValueForNonString() {
        String expression = "$.bool";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathStringValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a string at JSON path \"" + expression + "\" but found: true");
    }

    @Test
    void hasJsonPathNumberValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathNumberValue((CharSequence)"$.num", new Object[0]);
    }

    @Test
    void hasJsonPathNumberValueForNonNumber() {
        String expression = "$.bool";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathNumberValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a number at JSON path \"" + expression + "\" but found: true");
    }

    @Test
    void hasJsonPathBooleanValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathBooleanValue((CharSequence)"$.bool", new Object[0]);
    }

    @Test
    void hasJsonPathBooleanValueForNonBoolean() {
        String expression = "$.num";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathBooleanValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a boolean at JSON path \"" + expression + "\" but found: 5");
    }

    @Test
    void hasJsonPathArrayValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathArrayValue((CharSequence)"$.arr", new Object[0]);
    }

    @Test
    void hasJsonPathArrayValueForAnEmptyArray() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathArrayValue((CharSequence)"$.emptyArray", new Object[0]);
    }

    @Test
    void hasJsonPathArrayValueForNonArray() {
        String expression = "$.str";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathArrayValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected an array at JSON path \"" + expression + "\" but found: 'foo'");
    }

    @Test
    void hasJsonPathMapValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathMapValue((CharSequence)"$.colorMap", new Object[0]);
    }

    @Test
    void hasJsonPathMapValueForAnEmptyMap() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathMapValue((CharSequence)"$.emptyMap", new Object[0]);
    }

    @Test
    void hasJsonPathMapValueForNonMap() {
        String expression = "$.str";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathMapValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a map at JSON path \"" + expression + "\" but found: 'foo'");
    }

    @Test
    void extractingJsonPathValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathValue((CharSequence)"@.str", new Object[0]).isEqualTo((Object)"foo");
    }

    @Test
    void extractingJsonPathValueForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathValue((CharSequence)"@.bogus", new Object[0]).isNull();
    }

    @Test
    void extractingJsonPathStringValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathStringValue((CharSequence)"@.str", new Object[0]).isEqualTo((Object)"foo");
    }

    @Test
    void extractingJsonPathStringValueForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathStringValue((CharSequence)"@.bogus", new Object[0]).isNull();
    }

    @Test
    void extractingJsonPathStringValueForEmptyString() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathStringValue((CharSequence)"@.emptyString", new Object[0]).isEmpty();
    }

    @Test
    void extractingJsonPathStringValueForWrongType() {
        String expression = "$.num";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathStringValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a string at JSON path \"" + expression + "\" but found: 5");
    }

    @Test
    void extractingJsonPathNumberValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathNumberValue((CharSequence)"@.num", new Object[0]).isEqualTo((Object)5);
    }

    @Test
    void extractingJsonPathNumberValueForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathNumberValue((CharSequence)"@.bogus", new Object[0]).isNull();
    }

    @Test
    void extractingJsonPathNumberValueForWrongType() {
        String expression = "$.str";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathNumberValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a number at JSON path \"" + expression + "\" but found: 'foo'");
    }

    @Test
    void extractingJsonPathBooleanValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathBooleanValue((CharSequence)"@.bool", new Object[0]).isTrue();
    }

    @Test
    void extractingJsonPathBooleanValueForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathBooleanValue((CharSequence)"@.bogus", new Object[0]).isNull();
    }

    @Test
    void extractingJsonPathBooleanValueForWrongType() {
        String expression = "$.str";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathBooleanValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a boolean at JSON path \"" + expression + "\" but found: 'foo'");
    }

    @Test
    void extractingJsonPathArrayValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathArrayValue((CharSequence)"@.arr", new Object[0]).containsExactly(new Object[]{42});
    }

    @Test
    void extractingJsonPathArrayValueForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathArrayValue((CharSequence)"@.bogus", new Object[0]).isNull();
    }

    @Test
    void extractingJsonPathArrayValueForEmpty() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathArrayValue((CharSequence)"@.emptyArray", new Object[0]).isEmpty();
    }

    @Test
    void extractingJsonPathArrayValueForWrongType() {
        String expression = "$.str";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathArrayValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected an array at JSON path \"" + expression + "\" but found: 'foo'");
    }

    @Test
    void extractingJsonPathMapValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathMapValue((CharSequence)"@.colorMap", new Object[0]).contains(new Map.Entry[]{Assertions.entry((Object)"red", (Object)"rojo")});
    }

    @Test
    void extractingJsonPathMapValueForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathMapValue((CharSequence)"@.bogus", new Object[0]).isNull();
    }

    @Test
    void extractingJsonPathMapValueForEmpty() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathMapValue((CharSequence)"@.emptyMap", new Object[0]).isEmpty();
    }

    @Test
    void extractingJsonPathMapValueForWrongType() {
        String expression = "$.str";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathMapValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a map at JSON path \"" + expression + "\" but found: 'foo'");
    }

    @Test
    void isNullWhenActualIsNullShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(null))).isNull();
    }

    private File createFile(String content) throws IOException {
        File file = this.temp;
        FileCopyUtils.copy((byte[])content.getBytes(), (File)file);
        return file;
    }

    private InputStream createInputStream(String content) {
        return new ByteArrayInputStream(content.getBytes());
    }

    private Resource createResource(String content) {
        return new ByteArrayResource(content.getBytes());
    }

    private static String loadJson(String path) {
        try {
            ClassPathResource resource = new ClassPathResource(path, JsonContentAssertTests.class);
            return new String(FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream()));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private AssertProvider<JsonContentAssert> forJson(String json) {
        return () -> new JsonContentAssert(JsonContentAssertTests.class, (CharSequence)json);
    }
}

