/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import com.jayway.jsonpath.Configuration;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.json.ExampleObject;
import org.springframework.boot.test.json.JsonContent;
import org.springframework.boot.test.json.JsonContentAssert;
import org.springframework.core.ResolvableType;

class JsonContentTests {
    private static final String JSON = "{\"name\":\"spring\", \"age\":100}";
    private static final ResolvableType TYPE = ResolvableType.forClass(ExampleObject.class);

    JsonContentTests() {
    }

    @Test
    void createWhenResourceLoadClassIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new JsonContent(null, TYPE, JSON, Configuration.defaultConfiguration())).withMessageContaining("ResourceLoadClass must not be null");
    }

    @Test
    void createWhenJsonIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new JsonContent(this.getClass(), TYPE, null, Configuration.defaultConfiguration())).withMessageContaining("JSON must not be null");
    }

    @Test
    void createWhenConfigurationIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new JsonContent(this.getClass(), TYPE, JSON, null)).withMessageContaining("Configuration must not be null");
    }

    @Test
    void createWhenTypeIsNullShouldCreateContent() {
        JsonContent content = new JsonContent(this.getClass(), null, JSON, Configuration.defaultConfiguration());
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)content)).isNotNull();
    }

    @Test
    void assertThatShouldReturnJsonContentAssert() {
        JsonContent content = new JsonContent(this.getClass(), TYPE, JSON, Configuration.defaultConfiguration());
        Assertions.assertThat((Object)content.assertThat()).isInstanceOf(JsonContentAssert.class);
    }

    @Test
    void getJsonShouldReturnJson() {
        JsonContent content = new JsonContent(this.getClass(), TYPE, JSON, Configuration.defaultConfiguration());
        Assertions.assertThat((String)content.getJson()).isEqualTo(JSON);
    }

    @Test
    void toStringWhenHasTypeShouldReturnString() {
        JsonContent content = new JsonContent(this.getClass(), TYPE, JSON, Configuration.defaultConfiguration());
        Assertions.assertThat((String)content.toString()).isEqualTo("JsonContent {\"name\":\"spring\", \"age\":100} created from " + TYPE);
    }

    @Test
    void toStringWhenHasNoTypeShouldReturnString() {
        JsonContent content = new JsonContent(this.getClass(), null, JSON, Configuration.defaultConfiguration());
        Assertions.assertThat((String)content.toString()).isEqualTo("JsonContent {\"name\":\"spring\", \"age\":100}");
    }
}

