/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.json.ExampleObject;
import org.springframework.boot.test.json.ObjectContentAssert;

class ObjectContentAssertTests {
    private static final ExampleObject SOURCE = new ExampleObject();
    private static final ExampleObject DIFFERENT = new ExampleObject();

    ObjectContentAssertTests() {
    }

    @Test
    void isEqualToWhenObjectsAreEqualShouldPass() {
        ((ObjectContentAssert)Assertions.assertThat(this.forObject(SOURCE))).isEqualTo((Object)SOURCE);
    }

    @Test
    void isEqualToWhenObjectsAreDifferentShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> {
            ObjectContentAssert cfr_ignored_0 = (ObjectContentAssert)((ObjectContentAssert)Assertions.assertThat(this.forObject(SOURCE))).isEqualTo((Object)DIFFERENT);
        });
    }

    @Test
    void asArrayForArrayShouldReturnObjectArrayAssert() {
        ExampleObject[] source = new ExampleObject[]{SOURCE};
        ((ObjectContentAssert)Assertions.assertThat(this.forObject(source))).asArray().containsExactly(new Object[]{SOURCE});
    }

    @Test
    void asArrayForNonArrayShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ObjectContentAssert)Assertions.assertThat(this.forObject(SOURCE))).asArray());
    }

    @Test
    void asMapForMapShouldReturnMapAssert() {
        Map<String, ExampleObject> source = Collections.singletonMap("a", SOURCE);
        ((ObjectContentAssert)Assertions.assertThat(this.forObject(source))).asMap().containsEntry((Object)"a", (Object)SOURCE);
    }

    @Test
    void asMapForNonMapShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ObjectContentAssert)Assertions.assertThat(this.forObject(SOURCE))).asMap());
    }

    private AssertProvider<ObjectContentAssert<Object>> forObject(Object source) {
        return () -> new ObjectContentAssert(source);
    }

    static {
        DIFFERENT.setAge(123);
    }
}

