/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.json.ExampleObject;
import org.springframework.boot.test.json.ObjectContent;
import org.springframework.boot.test.json.ObjectContentAssert;
import org.springframework.core.ResolvableType;

class ObjectContentTests {
    private static final ExampleObject OBJECT = new ExampleObject();
    private static final ResolvableType TYPE = ResolvableType.forClass(ExampleObject.class);

    ObjectContentTests() {
    }

    @Test
    void createWhenObjectIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new ObjectContent(TYPE, null)).withMessageContaining("Object must not be null");
    }

    @Test
    void createWhenTypeIsNullShouldCreateContent() {
        ObjectContent content = new ObjectContent(null, (Object)OBJECT);
        ((ObjectContentAssert)Assertions.assertThat((AssertProvider)content)).isNotNull();
    }

    @Test
    void assertThatShouldReturnObjectContentAssert() {
        ObjectContent content = new ObjectContent(TYPE, (Object)OBJECT);
        Assertions.assertThat((Object)content.assertThat()).isInstanceOf(ObjectContentAssert.class);
    }

    @Test
    void getObjectShouldReturnObject() {
        ObjectContent content = new ObjectContent(TYPE, (Object)OBJECT);
        Assertions.assertThat((Object)content.getObject()).isEqualTo((Object)OBJECT);
    }

    @Test
    void toStringWhenHasTypeShouldReturnString() {
        ObjectContent content = new ObjectContent(TYPE, (Object)OBJECT);
        Assertions.assertThat((String)content.toString()).isEqualTo("ObjectContent " + OBJECT + " created from " + TYPE);
    }

    @Test
    void toStringWhenHasNoTypeShouldReturnString() {
        ObjectContent content = new ObjectContent(null, (Object)OBJECT);
        Assertions.assertThat((String)content.toString()).isEqualTo("ObjectContent " + OBJECT);
    }
}

