/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.BDDMockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.example.ExampleService;
import org.springframework.boot.test.mock.mockito.example.ExampleServiceCaller;
import org.springframework.boot.test.mock.mockito.example.FailingExampleService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
class MockBeanOnScopedProxyTests {
    @MockBean
    private ExampleService exampleService;
    @Autowired
    private ExampleServiceCaller caller;

    MockBeanOnScopedProxyTests() {
    }

    @Test
    void testMocking() {
        BDDMockito.given((Object)this.caller.getService().greeting()).willReturn((Object)"Boot");
        Assertions.assertThat((String)this.caller.sayGreeting()).isEqualTo("I say Boot");
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={ExampleServiceCaller.class})
    static class Config {
        Config() {
        }

        @Bean
        @Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
        ExampleService exampleService() {
            return new FailingExampleService();
        }
    }
}

