/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.example.CustomQualifier;
import org.springframework.boot.test.mock.mockito.example.CustomQualifierExampleService;
import org.springframework.boot.test.mock.mockito.example.ExampleService;
import org.springframework.boot.test.mock.mockito.example.ExampleServiceCaller;
import org.springframework.boot.test.mock.mockito.example.RealExampleService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
class MockBeanOnTestFieldForExistingBeanWithQualifierIntegrationTests {
    @MockBean
    @CustomQualifier
    private ExampleService service;
    @Autowired
    private ExampleServiceCaller caller;
    @Autowired
    private ApplicationContext applicationContext;

    MockBeanOnTestFieldForExistingBeanWithQualifierIntegrationTests() {
    }

    @Test
    void testMocking() {
        this.caller.sayGreeting();
        ((ExampleService)Mockito.verify((Object)this.service)).greeting();
    }

    @Test
    void onlyQualifiedBeanIsReplaced() {
        Assertions.assertThat((Object)this.applicationContext.getBean("service")).isSameAs((Object)this.service);
        ExampleService anotherService = (ExampleService)this.applicationContext.getBean("anotherService", ExampleService.class);
        Assertions.assertThat((String)anotherService.greeting()).isEqualTo("Another");
    }

    @Configuration(proxyBeanMethods=false)
    static class TestConfig {
        TestConfig() {
        }

        @Bean
        CustomQualifierExampleService service() {
            return new CustomQualifierExampleService();
        }

        @Bean
        ExampleService anotherService() {
            return new RealExampleService("Another");
        }

        @Bean
        ExampleServiceCaller controller(@CustomQualifier ExampleService service) {
            return new ExampleServiceCaller(service);
        }
    }
}

