/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.BDDMockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.example.ExampleService;
import org.springframework.boot.test.mock.mockito.example.ExampleServiceCaller;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.BEFORE_EACH_TEST_METHOD)
class MockBeanWithDirtiesContextClassModeBeforeMethodIntegrationTests {
    @MockBean
    private ExampleService exampleService;
    @Autowired
    private ExampleServiceCaller caller;

    MockBeanWithDirtiesContextClassModeBeforeMethodIntegrationTests() {
    }

    @Test
    void testMocking() throws Exception {
        BDDMockito.given((Object)this.exampleService.greeting()).willReturn((Object)"Boot");
        Assertions.assertThat((String)this.caller.sayGreeting()).isEqualTo("I say Boot");
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={ExampleServiceCaller.class})
    static class Config {
        Config() {
        }
    }
}

