/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.BDDMockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.example.ExampleGenericService;
import org.springframework.boot.test.mock.mockito.example.ExampleGenericServiceCaller;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
class MockBeanWithGenericsOnTestFieldForNewBeanIntegrationTests {
    @MockBean
    private ExampleGenericService<Integer> exampleIntegerService;
    @MockBean
    private ExampleGenericService<String> exampleStringService;
    @Autowired
    private ExampleGenericServiceCaller caller;

    MockBeanWithGenericsOnTestFieldForNewBeanIntegrationTests() {
    }

    @Test
    void testMocking() {
        BDDMockito.given((Object)this.exampleIntegerService.greeting()).willReturn((Object)200);
        BDDMockito.given((Object)this.exampleStringService.greeting()).willReturn((Object)"Boot");
        Assertions.assertThat((String)this.caller.sayGreeting()).isEqualTo("I say 200 Boot");
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={ExampleGenericServiceCaller.class})
    static class Config {
        Config() {
        }
    }
}

