/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.BDDMockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
class MockBeanWithInjectedFieldIntegrationTests {
    @MockBean
    private MyService myService;

    MockBeanWithInjectedFieldIntegrationTests() {
    }

    @Test
    void fieldInjectionIntoMyServiceMockIsNotAttempted() {
        BDDMockito.given((Object)this.myService.getCount()).willReturn((Object)5);
        Assertions.assertThat((int)this.myService.getCount()).isEqualTo(5);
    }

    static interface MyRepository {
        public List<Object> findAll();
    }

    static class MyService {
        @Autowired
        private MyRepository repository;

        MyService() {
        }

        int getCount() {
            return this.repository.findAll().size();
        }
    }
}

