/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.mock.MockCreationSettings;
import org.springframework.boot.test.mock.mockito.MockDefinition;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.QualifierDefinition;
import org.springframework.boot.test.mock.mockito.example.ExampleExtraInterface;
import org.springframework.boot.test.mock.mockito.example.ExampleService;
import org.springframework.core.ResolvableType;

class MockDefinitionTests {
    private static final ResolvableType EXAMPLE_SERVICE_TYPE = ResolvableType.forClass(ExampleService.class);

    MockDefinitionTests() {
    }

    @Test
    void classToMockMustNotBeNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new MockDefinition(null, null, null, null, false, null, null)).withMessageContaining("TypeToMock must not be null");
    }

    @Test
    void createWithDefaults() {
        MockDefinition definition = new MockDefinition(null, EXAMPLE_SERVICE_TYPE, null, null, false, null, null);
        Assertions.assertThat((String)definition.getName()).isNull();
        Assertions.assertThat((Object)definition.getTypeToMock()).isEqualTo((Object)EXAMPLE_SERVICE_TYPE);
        Assertions.assertThat((Iterable)definition.getExtraInterfaces()).isEmpty();
        Assertions.assertThat((Comparable)definition.getAnswer()).isEqualTo((Object)Answers.RETURNS_DEFAULTS);
        Assertions.assertThat((boolean)definition.isSerializable()).isFalse();
        Assertions.assertThat((Comparable)definition.getReset()).isEqualTo((Object)MockReset.AFTER);
        Assertions.assertThat((Object)definition.getQualifier()).isNull();
    }

    @Test
    void createExplicit() {
        QualifierDefinition qualifier = (QualifierDefinition)Mockito.mock(QualifierDefinition.class);
        MockDefinition definition = new MockDefinition("name", EXAMPLE_SERVICE_TYPE, new Class[]{ExampleExtraInterface.class}, Answers.RETURNS_SMART_NULLS, true, MockReset.BEFORE, qualifier);
        Assertions.assertThat((String)definition.getName()).isEqualTo("name");
        Assertions.assertThat((Object)definition.getTypeToMock()).isEqualTo((Object)EXAMPLE_SERVICE_TYPE);
        Assertions.assertThat((Iterable)definition.getExtraInterfaces()).containsExactly((Object[])new Class[]{ExampleExtraInterface.class});
        Assertions.assertThat((Comparable)definition.getAnswer()).isEqualTo((Object)Answers.RETURNS_SMART_NULLS);
        Assertions.assertThat((boolean)definition.isSerializable()).isTrue();
        Assertions.assertThat((Comparable)definition.getReset()).isEqualTo((Object)MockReset.BEFORE);
        Assertions.assertThat((boolean)definition.isProxyTargetAware()).isFalse();
        Assertions.assertThat((Object)definition.getQualifier()).isEqualTo((Object)qualifier);
    }

    @Test
    void createMock() {
        MockDefinition definition = new MockDefinition("name", EXAMPLE_SERVICE_TYPE, new Class[]{ExampleExtraInterface.class}, Answers.RETURNS_SMART_NULLS, true, MockReset.BEFORE, null);
        ExampleService mock = (ExampleService)definition.createMock();
        MockCreationSettings settings = Mockito.mockingDetails((Object)mock).getMockCreationSettings();
        Assertions.assertThat((Object)mock).isInstanceOf(ExampleService.class);
        Assertions.assertThat((Object)mock).isInstanceOf(ExampleExtraInterface.class);
        Assertions.assertThat((String)settings.getMockName().toString()).isEqualTo("name");
        Assertions.assertThat((Object)settings.getDefaultAnswer()).isEqualTo((Object)Answers.RETURNS_SMART_NULLS);
        Assertions.assertThat((boolean)settings.isSerializable()).isTrue();
        Assertions.assertThat((Comparable)MockReset.get((Object)mock)).isEqualTo((Object)MockReset.BEFORE);
    }
}

