/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.example.ExampleService;

class MockResetTests {
    MockResetTests() {
    }

    @Test
    void noneAttachesReset() {
        ExampleService mock = (ExampleService)Mockito.mock(ExampleService.class);
        Assertions.assertThat((Comparable)MockReset.get((Object)mock)).isEqualTo((Object)MockReset.NONE);
    }

    @Test
    void withSettingsOfNoneAttachesReset() {
        ExampleService mock = (ExampleService)Mockito.mock(ExampleService.class, (MockSettings)MockReset.withSettings((MockReset)MockReset.NONE));
        Assertions.assertThat((Comparable)MockReset.get((Object)mock)).isEqualTo((Object)MockReset.NONE);
    }

    @Test
    void beforeAttachesReset() {
        ExampleService mock = (ExampleService)Mockito.mock(ExampleService.class, (MockSettings)MockReset.before());
        Assertions.assertThat((Comparable)MockReset.get((Object)mock)).isEqualTo((Object)MockReset.BEFORE);
    }

    @Test
    void afterAttachesReset() {
        ExampleService mock = (ExampleService)Mockito.mock(ExampleService.class, (MockSettings)MockReset.after());
        Assertions.assertThat((Comparable)MockReset.get((Object)mock)).isEqualTo((Object)MockReset.AFTER);
    }

    @Test
    void withSettingsAttachesReset() {
        ExampleService mock = (ExampleService)Mockito.mock(ExampleService.class, (MockSettings)MockReset.withSettings((MockReset)MockReset.BEFORE));
        Assertions.assertThat((Comparable)MockReset.get((Object)mock)).isEqualTo((Object)MockReset.BEFORE);
    }

    @Test
    void apply() {
        ExampleService mock = (ExampleService)Mockito.mock(ExampleService.class, (MockSettings)MockReset.apply((MockReset)MockReset.AFTER, (MockSettings)Mockito.withSettings()));
        Assertions.assertThat((Comparable)MockReset.get((Object)mock)).isEqualTo((Object)MockReset.AFTER);
    }
}

