/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.MockitoContextCustomizerFactory;
import org.springframework.test.context.ContextCustomizer;

class MockitoContextCustomizerFactoryTests {
    private final MockitoContextCustomizerFactory factory = new MockitoContextCustomizerFactory();

    MockitoContextCustomizerFactoryTests() {
    }

    @BeforeEach
    void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    void getContextCustomizerWithoutAnnotationReturnsCustomizer() {
        ContextCustomizer customizer = this.factory.createContextCustomizer(NoMockBeanAnnotation.class, null);
        Assertions.assertThat((Object)customizer).isNotNull();
    }

    @Test
    void getContextCustomizerWithAnnotationReturnsCustomizer() {
        ContextCustomizer customizer = this.factory.createContextCustomizer(WithMockBeanAnnotation.class, null);
        Assertions.assertThat((Object)customizer).isNotNull();
    }

    @Test
    void getContextCustomizerUsesMocksAsCacheKey() {
        ContextCustomizer customizer = this.factory.createContextCustomizer(WithMockBeanAnnotation.class, null);
        Assertions.assertThat((Object)customizer).isNotNull();
        ContextCustomizer same = this.factory.createContextCustomizer(WithSameMockBeanAnnotation.class, null);
        Assertions.assertThat((Object)customizer).isNotNull();
        ContextCustomizer different = this.factory.createContextCustomizer(WithDifferentMockBeanAnnotation.class, null);
        Assertions.assertThat((Object)different).isNotNull();
        Assertions.assertThat((int)customizer.hashCode()).isEqualTo(same.hashCode());
        Assertions.assertThat((int)customizer.hashCode()).isNotEqualTo(different.hashCode());
        Assertions.assertThat((Object)customizer).isEqualTo((Object)customizer);
        Assertions.assertThat((Object)customizer).isEqualTo((Object)same);
        Assertions.assertThat((Object)customizer).isNotEqualTo((Object)different);
    }

    static interface Service2 {
    }

    static interface Service1 {
    }

    @MockBean(value={Service1.class})
    static class WithDifferentMockBeanAnnotation {
        WithDifferentMockBeanAnnotation() {
        }
    }

    @MockBean(value={Service2.class, Service1.class})
    static class WithSameMockBeanAnnotation {
        WithSameMockBeanAnnotation() {
        }
    }

    @MockBean(value={Service1.class, Service2.class})
    static class WithMockBeanAnnotation {
        WithMockBeanAnnotation() {
        }
    }

    static class NoMockBeanAnnotation {
        NoMockBeanAnnotation() {
        }
    }
}

