/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.MockitoPostProcessor;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.boot.test.mock.mockito.example.ExampleService;
import org.springframework.boot.test.mock.mockito.example.FailingExampleService;
import org.springframework.boot.test.mock.mockito.example.RealExampleService;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

class MockitoPostProcessorTests {
    MockitoPostProcessorTests() {
    }

    @Test
    void cannotMockMultipleBeans() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        MockitoPostProcessor.register((BeanDefinitionRegistry)context);
        context.register(new Class[]{MultipleBeans.class});
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((AnnotationConfigApplicationContext)context).refresh()).withMessageContaining("Unable to register mock bean " + ExampleService.class.getName() + " expected a single matching bean to replace but found [example1, example2]");
    }

    @Test
    void cannotMockMultipleQualifiedBeans() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        MockitoPostProcessor.register((BeanDefinitionRegistry)context);
        context.register(new Class[]{MultipleQualifiedBeans.class});
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((AnnotationConfigApplicationContext)context).refresh()).withMessageContaining("Unable to register mock bean " + ExampleService.class.getName() + " expected a single matching bean to replace but found [example1, example3]");
    }

    @Test
    void canMockBeanProducedByFactoryBeanWithObjectTypeAttribute() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        MockitoPostProcessor.register((BeanDefinitionRegistry)context);
        RootBeanDefinition factoryBeanDefinition = new RootBeanDefinition(TestFactoryBean.class);
        factoryBeanDefinition.setAttribute("factoryBeanObjectType", (Object)SomeInterface.class.getName());
        context.registerBeanDefinition("beanToBeMocked", (BeanDefinition)factoryBeanDefinition);
        context.register(new Class[]{MockedFactoryBean.class});
        context.refresh();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean("beanToBeMocked")).isMock()).isTrue();
    }

    @Test
    void canMockPrimaryBean() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        MockitoPostProcessor.register((BeanDefinitionRegistry)context);
        context.register(new Class[]{MockPrimaryBean.class});
        context.refresh();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)((MockPrimaryBean)context.getBean(MockPrimaryBean.class)).mock).isMock()).isTrue();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean(ExampleService.class)).isMock()).isTrue();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean("examplePrimary", ExampleService.class)).isMock()).isTrue();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean("exampleQualified", ExampleService.class)).isMock()).isFalse();
    }

    @Test
    void canMockQualifiedBeanWithPrimaryBeanPresent() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        MockitoPostProcessor.register((BeanDefinitionRegistry)context);
        context.register(new Class[]{MockQualifiedBean.class});
        context.refresh();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)((MockQualifiedBean)context.getBean(MockQualifiedBean.class)).mock).isMock()).isTrue();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean(ExampleService.class)).isMock()).isFalse();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean("examplePrimary", ExampleService.class)).isMock()).isFalse();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean("exampleQualified", ExampleService.class)).isMock()).isTrue();
    }

    @Test
    void canSpyPrimaryBean() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        MockitoPostProcessor.register((BeanDefinitionRegistry)context);
        context.register(new Class[]{SpyPrimaryBean.class});
        context.refresh();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)((SpyPrimaryBean)context.getBean(SpyPrimaryBean.class)).spy).isSpy()).isTrue();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean(ExampleService.class)).isSpy()).isTrue();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean("examplePrimary", ExampleService.class)).isSpy()).isTrue();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean("exampleQualified", ExampleService.class)).isSpy()).isFalse();
    }

    @Test
    void canSpyQualifiedBeanWithPrimaryBeanPresent() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        MockitoPostProcessor.register((BeanDefinitionRegistry)context);
        context.register(new Class[]{SpyQualifiedBean.class});
        context.refresh();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)((SpyQualifiedBean)context.getBean(SpyQualifiedBean.class)).spy).isSpy()).isTrue();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean(ExampleService.class)).isSpy()).isFalse();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean("examplePrimary", ExampleService.class)).isSpy()).isFalse();
        Assertions.assertThat((boolean)Mockito.mockingDetails((Object)context.getBean("exampleQualified", ExampleService.class)).isSpy()).isTrue();
    }

    static class TestBean
    implements SomeInterface {
        TestBean() {
        }
    }

    static interface SomeInterface {
    }

    static class TestFactoryBean
    implements FactoryBean<Object> {
        TestFactoryBean() {
        }

        public Object getObject() {
            return new TestBean();
        }

        public Class<?> getObjectType() {
            return null;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class SpyQualifiedBean {
        @SpyBean
        @Qualifier(value="test")
        private ExampleService spy;

        SpyQualifiedBean() {
        }

        @Bean
        @Qualifier(value="test")
        ExampleService exampleQualified() {
            return new RealExampleService("qualified");
        }

        @Bean
        @Primary
        ExampleService examplePrimary() {
            return new RealExampleService("primary");
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class SpyPrimaryBean {
        @SpyBean
        private ExampleService spy;

        SpyPrimaryBean() {
        }

        @Bean
        @Qualifier(value="test")
        ExampleService exampleQualified() {
            return new RealExampleService("qualified");
        }

        @Bean
        @Primary
        ExampleService examplePrimary() {
            return new RealExampleService("primary");
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class MockQualifiedBean {
        @MockBean
        @Qualifier(value="test")
        private ExampleService mock;

        MockQualifiedBean() {
        }

        @Bean
        @Qualifier(value="test")
        ExampleService exampleQualified() {
            return new RealExampleService("qualified");
        }

        @Bean
        @Primary
        ExampleService examplePrimary() {
            return new RealExampleService("primary");
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class MockPrimaryBean {
        @MockBean
        private ExampleService mock;

        MockPrimaryBean() {
        }

        @Bean
        @Qualifier(value="test")
        ExampleService exampleQualified() {
            return new RealExampleService("qualified");
        }

        @Bean
        @Primary
        ExampleService examplePrimary() {
            return new RealExampleService("primary");
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class MultipleQualifiedBeans {
        @MockBean
        @Qualifier(value="test")
        private ExampleService mock;

        MultipleQualifiedBeans() {
        }

        @Bean
        @Qualifier(value="test")
        ExampleService example1() {
            return new FailingExampleService();
        }

        @Bean
        ExampleService example2() {
            return new FailingExampleService();
        }

        @Bean
        @Qualifier(value="test")
        ExampleService example3() {
            return new FailingExampleService();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @MockBean(value={ExampleService.class})
    static class MultipleBeans {
        MultipleBeans() {
        }

        @Bean
        ExampleService example1() {
            return new FailingExampleService();
        }

        @Bean
        ExampleService example2() {
            return new FailingExampleService();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @MockBean(value={SomeInterface.class})
    static class MockedFactoryBean {
        MockedFactoryBean() {
        }

        @Bean
        TestFactoryBean testFactoryBean() {
            return new TestFactoryBean();
        }
    }
}

