/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.io.InputStream;
import java.lang.reflect.Field;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.MockDefinition;
import org.springframework.boot.test.mock.mockito.MockitoPostProcessor;
import org.springframework.boot.test.mock.mockito.MockitoTestExecutionListener;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

class MockitoTestExecutionListenerTests {
    private MockitoTestExecutionListener listener = new MockitoTestExecutionListener();
    @Mock
    private ApplicationContext applicationContext;
    @Mock
    private MockitoPostProcessor postProcessor;
    @Captor
    private ArgumentCaptor<Field> fieldCaptor;

    MockitoTestExecutionListenerTests() {
    }

    @BeforeEach
    void setup() {
        MockitoAnnotations.initMocks((Object)this);
        BDDMockito.given((Object)this.applicationContext.getBean(MockitoPostProcessor.class)).willReturn((Object)this.postProcessor);
    }

    @Test
    void prepareTestInstanceShouldInitMockitoAnnotations() throws Exception {
        WithMockitoAnnotations instance = new WithMockitoAnnotations();
        this.listener.prepareTestInstance(this.mockTestContext(instance));
        Assertions.assertThat((InputStream)instance.mock).isNotNull();
        Assertions.assertThat(instance.captor).isNotNull();
    }

    @Test
    void prepareTestInstanceShouldInjectMockBean() throws Exception {
        WithMockBean instance = new WithMockBean();
        this.listener.prepareTestInstance(this.mockTestContext(instance));
        ((MockitoPostProcessor)Mockito.verify((Object)this.postProcessor)).inject((Field)this.fieldCaptor.capture(), ArgumentMatchers.eq((Object)instance), (Definition)ArgumentMatchers.any(MockDefinition.class));
        Assertions.assertThat((String)((Field)this.fieldCaptor.getValue()).getName()).isEqualTo("mockBean");
    }

    @Test
    void beforeTestMethodShouldDoNothingWhenDirtiesContextAttributeIsNotSet() throws Exception {
        WithMockBean instance = new WithMockBean();
        this.listener.beforeTestMethod(this.mockTestContext(instance));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.postProcessor});
    }

    @Test
    void beforeTestMethodShouldInjectMockBeanWhenDirtiesContextAttributeIsSet() throws Exception {
        WithMockBean instance = new WithMockBean();
        TestContext mockTestContext = this.mockTestContext(instance);
        BDDMockito.given((Object)mockTestContext.getAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE)).willReturn((Object)Boolean.TRUE);
        this.listener.beforeTestMethod(mockTestContext);
        ((MockitoPostProcessor)Mockito.verify((Object)this.postProcessor)).inject((Field)this.fieldCaptor.capture(), ArgumentMatchers.eq((Object)instance), (Definition)((MockDefinition)ArgumentMatchers.any()));
        Assertions.assertThat((String)((Field)this.fieldCaptor.getValue()).getName()).isEqualTo("mockBean");
    }

    private TestContext mockTestContext(Object instance) {
        TestContext testContext = (TestContext)Mockito.mock(TestContext.class);
        BDDMockito.given((Object)testContext.getTestInstance()).willReturn(instance);
        BDDMockito.given((Object)testContext.getTestClass()).willReturn(instance.getClass());
        BDDMockito.given((Object)testContext.getApplicationContext()).willReturn((Object)this.applicationContext);
        return testContext;
    }

    static class WithMockBean {
        @MockBean
        InputStream mockBean;

        WithMockBean() {
        }
    }

    static class WithMockitoAnnotations {
        @Mock
        InputStream mock;
        @Captor
        ArgumentCaptor<InputStream> captor;

        WithMockitoAnnotations() {
        }
    }
}

